/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPublishMethodHandler
implements StateAwareMethodListener<BasicPublishBody> {
    private static final Logger _logger = Logger.getLogger(BasicPublishMethodHandler.class);
    private static final BasicPublishMethodHandler _instance = new BasicPublishMethodHandler();

    public static BasicPublishMethodHandler getInstance() {
        return _instance;
    }

    private BasicPublishMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicPublishBody body, int channelId) throws AMQException {
        VirtualHost vHost;
        Exchange e;
        AMQShortString exchange;
        AMQProtocolSession session = stateManager.getProtocolSession();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Publish received on channel " + channelId));
        }
        if ((exchange = body.getExchange()) == null) {
            exchange = ExchangeDefaults.DEFAULT_EXCHANGE_NAME;
        }
        if ((e = (vHost = session.getVirtualHost()).getExchangeRegistry().getExchange(exchange)) == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Unknown exchange name");
        }
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (!vHost.getAccessManager().authorisePublish(session, body.getImmediate(), body.getMandatory(), body.getRoutingKey(), e)) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "Permission denied");
        }
        MessagePublishInfo info = session.getMethodRegistry().getProtocolVersionMethodConverter().convertToInfo((AMQMethodBody)body);
        info.setExchange(exchange);
        channel.setPublishFrame(info, e);
    }
}

