/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.BasicRecoverSyncBody;
import org.apache.qpid.framing.BasicRecoverSyncOkBody;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.amqp_0_9.MethodRegistry_0_9;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicRecoverSyncMethodHandler
implements StateAwareMethodListener<BasicRecoverSyncBody> {
    private static final Logger _logger = Logger.getLogger(BasicRecoverSyncMethodHandler.class);
    private static final BasicRecoverSyncMethodHandler _instance = new BasicRecoverSyncMethodHandler();

    public static BasicRecoverSyncMethodHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicRecoverSyncBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        _logger.debug((Object)("Recover received on protocol session " + session + " and channel " + channelId));
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.resend(body.getRequeue());
        if (session.getProtocolVersion().equals((Object)ProtocolVersion.v0_9)) {
            MethodRegistry_0_9 methodRegistry = (MethodRegistry_0_9)session.getMethodRegistry();
            BasicRecoverSyncOkBody recoverOk = methodRegistry.createBasicRecoverSyncOkBody();
            session.writeFrame((AMQDataBlock)recoverOk.generateFrame(channelId));
        }
    }
}

