/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.ConnectionOpenOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.state.AMQState;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionOpenMethodHandler
implements StateAwareMethodListener<ConnectionOpenBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionOpenMethodHandler.class);
    private static ConnectionOpenMethodHandler _instance = new ConnectionOpenMethodHandler();

    public static ConnectionOpenMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionOpenMethodHandler() {
    }

    private static AMQShortString generateClientID() {
        return new AMQShortString(Long.toString(System.currentTimeMillis()));
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionOpenBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        String virtualHostName = body.getVirtualHost() != null && body.getVirtualHost().charAt(0) == '/' ? new StringBuilder(body.getVirtualHost().subSequence(1, body.getVirtualHost().length())).toString() : (body.getVirtualHost() == null ? null : String.valueOf(body.getVirtualHost()));
        VirtualHost virtualHost = stateManager.getVirtualHostRegistry().getVirtualHost(virtualHostName);
        if (virtualHost == null) {
            throw body.getConnectionException(AMQConstant.NOT_FOUND, "Unknown virtual host: '" + virtualHostName + "'");
        }
        session.setVirtualHost(virtualHost);
        if (!virtualHost.getAccessManager().authoriseConnect(session, virtualHost)) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "Permission denied");
        }
        if (session.getContextKey() == null) {
            session.setContextKey(ConnectionOpenMethodHandler.generateClientID());
        }
        MethodRegistry methodRegistry = session.getMethodRegistry();
        ConnectionOpenOkBody responseBody = methodRegistry.createConnectionOpenOkBody(body.getVirtualHost());
        stateManager.changeState(AMQState.CONNECTION_OPEN);
        session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
    }
}

