/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.UsernamePrincipal;
import org.apache.qpid.server.state.AMQState;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionStartOkMethodHandler
implements StateAwareMethodListener<ConnectionStartOkBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionStartOkMethodHandler.class);
    private static ConnectionStartOkMethodHandler _instance = new ConnectionStartOkMethodHandler();

    public static ConnectionStartOkMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionStartOkMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionStartOkBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        _logger.info((Object)("SASL Mechanism selected: " + body.getMechanism()));
        _logger.info((Object)("Locale selected: " + body.getLocale()));
        AuthenticationManager authMgr = ApplicationRegistry.getInstance().getAuthenticationManager();
        SaslServer ss = null;
        try {
            ss = authMgr.createSaslServer(String.valueOf(body.getMechanism()), session.getLocalFQDN());
            if (ss == null) {
                throw body.getConnectionException(AMQConstant.RESOURCE_ERROR, "Unable to create SASL Server:" + body.getMechanism());
            }
            session.setSaslServer(ss);
            AuthenticationResult authResult = authMgr.authenticate(ss, body.getResponse());
            if (session.getClientProperties() == null) {
                session.setClientProperties(body.getClientProperties());
            }
            MethodRegistry methodRegistry = session.getMethodRegistry();
            switch (authResult.status) {
                case ERROR: {
                    Exception cause = authResult.getCause();
                    _logger.info((Object)("Authentication failed:" + (cause == null ? "" : cause.getMessage())));
                    stateManager.changeState(AMQState.CONNECTION_CLOSING);
                    ConnectionCloseBody closeBody = methodRegistry.createConnectionCloseBody(AMQConstant.NOT_ALLOWED.getCode(), AMQConstant.NOT_ALLOWED.getName(), body.getClazz(), body.getMethod());
                    session.writeFrame((AMQDataBlock)closeBody.generateFrame(0));
                    this.disposeSaslServer(session);
                    break;
                }
                case SUCCESS: {
                    _logger.info((Object)("Connected as: " + ss.getAuthorizationID()));
                    session.setAuthorizedID(new UsernamePrincipal(ss.getAuthorizationID()));
                    stateManager.changeState(AMQState.CONNECTION_NOT_TUNED);
                    ConnectionTuneBody tuneBody = methodRegistry.createConnectionTuneBody(65535, (long)ConnectionStartOkMethodHandler.getConfiguredFrameSize(), ApplicationRegistry.getInstance().getConfiguration().getHeartBeatDelay());
                    session.writeFrame((AMQDataBlock)tuneBody.generateFrame(0));
                    break;
                }
                case CONTINUE: {
                    stateManager.changeState(AMQState.CONNECTION_NOT_AUTH);
                    ConnectionSecureBody secureBody = methodRegistry.createConnectionSecureBody(authResult.challenge);
                    session.writeFrame((AMQDataBlock)secureBody.generateFrame(0));
                }
            }
        }
        catch (SaslException e) {
            this.disposeSaslServer(session);
            throw new AMQException("SASL error: " + e, (Throwable)e);
        }
    }

    private void disposeSaslServer(AMQProtocolSession ps) {
        SaslServer ss = ps.getSaslServer();
        if (ss != null) {
            ps.setSaslServer(null);
            try {
                ss.dispose();
            }
            catch (SaslException e) {
                _logger.error((Object)("Error disposing of Sasl server: " + e));
            }
        }
    }

    static int getConfiguredFrameSize() {
        ServerConfiguration config = ApplicationRegistry.getInstance().getConfiguration();
        int framesize = config.getFrameSize();
        _logger.info((Object)("Framesize set to " + framesize));
        return framesize;
    }
}

