/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInvalidRoutingKeyException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueBindOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueBindHandler
implements StateAwareMethodListener<QueueBindBody> {
    private static final Logger _log = Logger.getLogger(QueueBindHandler.class);
    private static final QueueBindHandler _instance = new QueueBindHandler();

    public static QueueBindHandler getInstance() {
        return _instance;
    }

    private QueueBindHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueBindBody body, int channelId) throws AMQException {
        AMQShortString routingKey;
        AMQQueue queue;
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        if (body.getQueue() == null) {
            AMQChannel channel = session.getChannel(channelId);
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            queue = channel.getDefaultQueue();
            if (queue == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "No default queue defined on channel and queue was null");
            }
            routingKey = body.getRoutingKey() == null ? queue.getName() : body.getRoutingKey().intern();
        } else {
            queue = queueRegistry.getQueue(body.getQueue());
            AMQShortString aMQShortString = routingKey = body.getRoutingKey() == null ? AMQShortString.EMPTY_STRING : body.getRoutingKey().intern();
        }
        if (queue == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
        }
        Exchange exch = exchangeRegistry.getExchange(body.getExchange());
        if (exch == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Exchange " + body.getExchange() + " does not exist.");
        }
        try {
            if (!virtualHost.getAccessManager().authoriseBind(session, exch, queue, routingKey)) {
                throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "Permission denied");
            }
            if (!exch.isBound(routingKey, body.getArguments(), queue)) {
                queue.bind(exch, routingKey, body.getArguments());
            }
        }
        catch (AMQInvalidRoutingKeyException rke) {
            throw body.getChannelException(AMQConstant.INVALID_ROUTING_KEY, routingKey.toString());
        }
        catch (AMQException e) {
            throw body.getChannelException(AMQConstant.CHANNEL_ERROR, e.toString());
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding queue " + queue + " to exchange " + exch + " with routing key " + routingKey));
        }
        if (!body.getNowait()) {
            MethodRegistry methodRegistry = session.getMethodRegistry();
            QueueBindOkBody responseBody = methodRegistry.createQueueBindOkBody();
            session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
    }
}

