/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueDeclareHandler
implements StateAwareMethodListener<QueueDeclareBody> {
    private static final Logger _logger = Logger.getLogger(QueueDeclareHandler.class);
    private static final QueueDeclareHandler _instance = new QueueDeclareHandler();
    public boolean autoRegister = ApplicationRegistry.getInstance().getConfiguration().getQueueAutoRegister();
    private final AtomicInteger _counter = new AtomicInteger();

    public static QueueDeclareHandler getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void methodReceived(AMQStateManager stateManager, QueueDeclareBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        MessageStore store = virtualHost.getMessageStore();
        if (!body.getPassive() && !virtualHost.getAccessManager().authoriseCreateQueue(session, body.getAutoDelete(), body.getDurable(), body.getExclusive(), body.getNowait(), body.getPassive(), body.getQueue())) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "Permission denied");
        }
        AMQShortString queueName = body.getQueue() == null || body.getQueue().length() == 0 ? this.createName() : body.getQueue().intern();
        QueueRegistry queueRegistry2 = queueRegistry;
        synchronized (queueRegistry2) {
            AMQChannel channel;
            queue = queueRegistry.getQueue(queueName);
            if (queue == null) {
                if (body.getPassive()) {
                    String msg = "Queue: " + queueName + " not found on VirtualHost(" + virtualHost + ").";
                    throw body.getChannelException(AMQConstant.NOT_FOUND, msg);
                }
                queue = this.createQueue(queueName, body, virtualHost, session);
                if (queue.isDurable() && !queue.isAutoDelete()) {
                    store.createQueue(queue, body.getArguments());
                }
                queueRegistry.registerQueue(queue);
                if (this.autoRegister) {
                    Exchange defaultExchange = exchangeRegistry.getDefaultExchange();
                    queue.bind(defaultExchange, queueName, null);
                    _logger.info((Object)("Queue " + queueName + " bound to default exchange(" + defaultExchange.getName() + ")"));
                }
            } else if (queue.getOwner() != null && !session.getContextKey().equals(queue.getOwner())) {
                throw body.getChannelException(AMQConstant.ALREADY_EXISTS, "Cannot declare queue('" + queueName + "')," + " as exclusive queue with same name " + "declared on another client ID('" + queue.getOwner() + "')");
            }
            if ((channel = session.getChannel(channelId)) == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            channel.setDefaultQueue(queue);
        }
        if (!body.getNowait()) {
            MethodRegistry methodRegistry = session.getMethodRegistry();
            QueueDeclareOkBody responseBody = methodRegistry.createQueueDeclareOkBody(queueName, (long)queue.getMessageCount(), (long)queue.getConsumerCount());
            session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
            _logger.info((Object)("Queue " + queueName + " declared successfully"));
        }
    }

    protected AMQShortString createName() {
        return new AMQShortString("tmp_" + UUID.randomUUID());
    }

    protected AMQQueue createQueue(final AMQShortString queueName, QueueDeclareBody body, VirtualHost virtualHost, final AMQProtocolSession session) throws AMQException {
        final QueueRegistry registry = virtualHost.getQueueRegistry();
        AMQShortString owner = body.getExclusive() ? session.getContextKey() : null;
        final AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(queueName, body.getDurable(), owner, body.getAutoDelete(), virtualHost, body.getArguments());
        if (body.getExclusive() && !body.getDurable()) {
            final AMQProtocolSession.Task deleteQueueTask = new AMQProtocolSession.Task(){

                public void doTask(AMQProtocolSession session) throws AMQException {
                    if (registry.getQueue(queueName) == queue) {
                        queue.delete();
                    }
                }
            };
            session.addSessionCloseTask(deleteQueueTask);
            queue.addQueueDeleteTask(new AMQQueue.Task(){

                public void doTask(AMQQueue queue) {
                    session.removeSessionCloseTask(deleteQueueTask);
                }
            });
        }
        return queue;
    }
}

