/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.QueuePurgeOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuePurgeHandler
implements StateAwareMethodListener<QueuePurgeBody> {
    private static final QueuePurgeHandler _instance = new QueuePurgeHandler();
    private final boolean _failIfNotFound;

    public static QueuePurgeHandler getInstance() {
        return _instance;
    }

    public QueuePurgeHandler() {
        this(true);
    }

    public QueuePurgeHandler(boolean failIfNotFound) {
        this._failIfNotFound = failIfNotFound;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueuePurgeBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        AMQChannel channel = session.getChannel(channelId);
        if (body.getQueue() == null) {
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            queue = channel.getDefaultQueue();
            if (queue == null && this._failIfNotFound) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "No queue specified.");
            }
        } else {
            queue = queueRegistry.getQueue(body.getQueue());
        }
        if (queue == null) {
            if (this._failIfNotFound) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
            }
        } else {
            if (!virtualHost.getAccessManager().authorisePurge(session, queue)) {
                throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "Permission denied");
            }
            long purged = queue.clearQueue(channel.getStoreContext());
            if (!body.getNowait()) {
                MethodRegistry methodRegistry = session.getMethodRegistry();
                QueuePurgeOkBody responseBody = methodRegistry.createQueuePurgeOkBody(purged);
                session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
            }
        }
    }
}

