/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.management;

import java.io.IOException;
import javax.management.openmbean.TabularData;
import org.apache.qpid.server.management.MBeanAttribute;
import org.apache.qpid.server.management.MBeanOperation;
import org.apache.qpid.server.management.MBeanOperationParameter;

public interface LoggingManagement {
    public static final String TYPE = "LoggingManagement";
    public static final int VERSION = 1;
    public static final String[] COMPOSITE_ITEM_NAMES = new String[]{"LoggerName", "Level"};
    public static final String[] COMPOSITE_ITEM_DESCRIPTIONS = new String[]{"Name of the logger", "Level of the logger"};
    public static final String[] TABULAR_UNIQUE_INDEX = new String[]{COMPOSITE_ITEM_NAMES[0]};

    @MBeanAttribute(name="Log4jLogWatchInterval", description="The log4j xml configuration file LogWatch interval (in seconds). 0 indicates not being checked.")
    public Integer getLog4jLogWatchInterval();

    @MBeanAttribute(name="AvailableLoggerLevels", description="The values to which log output level can be set.")
    public String[] getAvailableLoggerLevels();

    @MBeanOperation(name="setRuntimeLoggerLevel", description="Set the runtime logging level for an active log4j logger.", impact=1)
    public boolean setRuntimeLoggerLevel(@MBeanOperationParameter(name="logger", description="Logger name") String var1, @MBeanOperationParameter(name="level", description="Logger level") String var2);

    @MBeanOperation(name="viewEffectiveRuntimeLoggerLevels", description="View the effective runtime logging level for active log4j logger's.", impact=0)
    public TabularData viewEffectiveRuntimeLoggerLevels();

    @MBeanOperation(name="setRuntimeRootLoggerLevel", description="Set the runtime logging level for the active log4j Root Logger.", impact=1)
    public boolean setRuntimeRootLoggerLevel(@MBeanOperationParameter(name="level", description="Logger level") String var1);

    @MBeanAttribute(name="getRuntimeRootLoggerLevel", description="Get the runtime logging level for the active log4j Root Logger.")
    public String getRuntimeRootLoggerLevel();

    @MBeanOperation(name="setConfigFileLoggerLevel", description="Set the logging level for an existing logger in the log4j xml configuration file", impact=1)
    public boolean setConfigFileLoggerLevel(@MBeanOperationParameter(name="logger", description="logger name") String var1, @MBeanOperationParameter(name="level", description="Logger level") String var2) throws IOException;

    @MBeanOperation(name="viewConfigFileLoggerLevels", description="Get the logging level defined for the logger's in the log4j xml configuration file.", impact=0)
    public TabularData viewConfigFileLoggerLevels() throws IOException;

    @MBeanOperation(name="setConfigFileRootLoggerLevel", description="Set the logging level for the Root Logger in the log4j xml configuration file.", impact=1)
    public boolean setConfigFileRootLoggerLevel(@MBeanOperationParameter(name="level", description="Logger level") String var1) throws IOException;

    @MBeanAttribute(name="getConfigFileRootLoggerLevel", description="Get the logging level for the Root Logger in the log4j xml configuration file.")
    public String getConfigFileRootLoggerLevel() throws IOException;
}

