/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.management;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.management.JMException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.qpid.server.logging.management.LoggingManagement;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.management.MBeanDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@MBeanDescription(value="Logging Management Interface")
public class LoggingManagementMBean
extends AMQManagedObject
implements LoggingManagement {
    private static final Logger _logger = Logger.getLogger(LoggingManagementMBean.class);
    private String _log4jConfigFileName;
    private int _log4jLogWatchInterval;
    private static final String[] LEVELS = new String[]{Level.ALL.toString(), Level.TRACE.toString(), Level.DEBUG.toString(), Level.INFO.toString(), Level.WARN.toString(), Level.ERROR.toString(), Level.FATAL.toString(), Level.OFF.toString()};
    static TabularType _loggerLevelTabularType;
    static CompositeType _loggerLevelCompositeType;

    public LoggingManagementMBean(String log4jConfigFileName, int log4jLogWatchInterval) throws JMException {
        super(LoggingManagement.class, "LoggingManagement", 1);
        this._log4jConfigFileName = log4jConfigFileName;
        this._log4jLogWatchInterval = log4jLogWatchInterval;
    }

    public String getObjectInstanceName() {
        return "LoggingManagement";
    }

    public Integer getLog4jLogWatchInterval() {
        return this._log4jLogWatchInterval;
    }

    public String[] getAvailableLoggerLevels() {
        return LEVELS;
    }

    public synchronized boolean setRuntimeLoggerLevel(String logger, String level) {
        Logger log;
        Level newLevel;
        try {
            newLevel = this.getLevel(level);
        }
        catch (Exception e) {
            return false;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        Boolean loggerExists = false;
        while (loggers.hasMoreElements()) {
            log = (Logger)loggers.nextElement();
            if (!log.getName().equals(logger)) continue;
            loggerExists = true;
            break;
        }
        if (!loggerExists.booleanValue()) {
            return false;
        }
        _logger.info((Object)("Setting level to " + level + " for logger: " + logger));
        log = Logger.getLogger((String)logger);
        log.setLevel(newLevel);
        return true;
    }

    public synchronized TabularData viewEffectiveRuntimeLoggerLevels() {
        if (_loggerLevelTabularType == null) {
            _logger.warn((Object)"TabluarData type not set up correctly");
            return null;
        }
        _logger.info((Object)"Getting levels for currently active log4j loggers");
        Enumeration loggers = LogManager.getCurrentLoggers();
        TabularDataSupport loggerLevelList = new TabularDataSupport(_loggerLevelTabularType);
        try {
            while (loggers.hasMoreElements()) {
                Logger logger = (Logger)loggers.nextElement();
                String loggerName = logger.getName();
                String level = logger.getEffectiveLevel().toString();
                Object[] itemData = new Object[]{loggerName, level};
                CompositeDataSupport loggerData = new CompositeDataSupport(_loggerLevelCompositeType, COMPOSITE_ITEM_NAMES, itemData);
                loggerLevelList.put(loggerData);
            }
        }
        catch (OpenDataException e) {
            _logger.warn((Object)("Unable to create logger level list due to :" + e));
            return null;
        }
        return loggerLevelList;
    }

    public synchronized String getRuntimeRootLoggerLevel() {
        Logger rootLogger = Logger.getRootLogger();
        return rootLogger.getLevel().toString();
    }

    public synchronized boolean setRuntimeRootLoggerLevel(String level) {
        Level newLevel;
        try {
            newLevel = this.getLevel(level);
        }
        catch (Exception e) {
            return false;
        }
        _logger.info((Object)("Setting RootLogger level to " + level));
        Logger log = Logger.getRootLogger();
        log.setLevel(newLevel);
        return true;
    }

    private Level getLevel(String level) throws Exception {
        Level newLevel = Level.toLevel((String)level);
        if (newLevel.equals((Object)Level.DEBUG) && !level.equalsIgnoreCase("debug")) {
            throw new Exception("Invalid level name");
        }
        return newLevel;
    }

    private synchronized Document parseConfigFile(String fileName) throws IOException {
        Document doc;
        if (fileName == null) {
            _logger.warn((Object)"No log4j XML configuration file has been set");
            throw new IOException("No log4j XML configuration file has been set");
        }
        File configFile = new File(fileName);
        if (!configFile.exists()) {
            _logger.warn((Object)("Specified log4j XML configuration file does not exist: " + fileName));
            throw new IOException("Specified log4j XML configuration file does not exist");
        }
        if (!configFile.canRead()) {
            _logger.warn((Object)("Specified log4j XML configuration file is not readable: " + fileName));
            throw new IOException("Specified log4j XML configuration file is not readable");
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        SaxErrorHandler errHandler = new SaxErrorHandler();
        try {
            docFactory.setValidating(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(errHandler);
            docBuilder.setEntityResolver((EntityResolver)new Log4jEntityResolver());
            doc = docBuilder.parse(fileName);
        }
        catch (ParserConfigurationException e) {
            _logger.warn((Object)("Unable to parse the log4j XML file due to possible configuration error: " + e));
            throw new IOException("Unable to parse the log4j XML file due to possible configuration error: " + e.getMessage());
        }
        catch (SAXException e) {
            _logger.warn((Object)("The specified log4j XML file is invalid: " + e));
            throw new IOException("The specified log4j XML file is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            _logger.warn((Object)("Unable to parse the specified log4j XML file" + e));
            throw new IOException("Unable to parse the specified log4j XML file", e);
        }
        return doc;
    }

    private synchronized boolean writeUpdatedConfigFile(String log4jConfigFileName, Document doc) throws IOException {
        File tmp;
        File log4jConfigFile = new File(log4jConfigFileName);
        if (!log4jConfigFile.canWrite()) {
            _logger.warn((Object)("Specified log4j XML configuration file is not writable: " + log4jConfigFile));
            throw new IOException("Specified log4j XML configuration file is not writable");
        }
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (Exception e) {
            _logger.warn((Object)("Could not create an XML transformer: " + e));
            return false;
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-system", "log4j.dtd");
        DOMSource source = new DOMSource(doc);
        try {
            tmp = File.createTempFile("LogManMBeanTemp", ".tmp");
            tmp.deleteOnExit();
            StreamResult result = new StreamResult(tmp);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            _logger.warn((Object)("Could not transform the XML into new file: " + e));
            return false;
        }
        catch (IOException e) {
            _logger.warn((Object)("Could not create the new file: " + e));
            return false;
        }
        File old = new File(log4jConfigFile.getAbsoluteFile() + ".old");
        if (old.exists()) {
            old.delete();
        }
        log4jConfigFile.renameTo(old);
        return tmp.renameTo(log4jConfigFile);
    }

    public synchronized TabularData viewConfigFileLoggerLevels() throws IOException {
        if (_loggerLevelTabularType == null) {
            _logger.warn((Object)"TabluarData type not set up correctly");
            return null;
        }
        _logger.info((Object)"Getting logger levels from log4j configuration file");
        Document doc = this.parseConfigFile(this._log4jConfigFileName);
        TabularDataSupport loggerLevelList = new TabularDataSupport(_loggerLevelTabularType);
        NodeList categoryElements = doc.getElementsByTagName("category");
        String priority = null;
        for (int i = 0; i < categoryElements.getLength(); ++i) {
            Element categoryElement = (Element)categoryElements.item(i);
            String categoryName = categoryElement.getAttribute("name");
            NodeList priorityElements = categoryElement.getElementsByTagName("priority");
            NodeList levelElements = categoryElement.getElementsByTagName("level");
            if (priorityElements.getLength() != 0) {
                Element priorityElement = (Element)priorityElements.item(0);
                priority = priorityElement.getAttribute("value").toUpperCase();
            } else {
                if (levelElements.getLength() == 0) continue;
                Element levelElement = (Element)levelElements.item(0);
                priority = levelElement.getAttribute("value").toUpperCase();
            }
            try {
                Object[] itemData = new Object[]{categoryName, priority};
                CompositeDataSupport loggerData = new CompositeDataSupport(_loggerLevelCompositeType, COMPOSITE_ITEM_NAMES, itemData);
                loggerLevelList.put(loggerData);
                continue;
            }
            catch (OpenDataException e) {
                _logger.warn((Object)("Unable to create logger level list due to :" + e));
                return null;
            }
        }
        NodeList loggerElements = doc.getElementsByTagName("logger");
        for (int i = 0; i < loggerElements.getLength(); ++i) {
            Element loggerElement = (Element)loggerElements.item(i);
            String loggerName = loggerElement.getAttribute("name");
            NodeList levelElements = loggerElement.getElementsByTagName("level");
            Element levelElement = (Element)levelElements.item(0);
            String level = levelElement.getAttribute("value").toUpperCase();
            try {
                Object[] itemData = new Object[]{loggerName, level};
                CompositeDataSupport loggerData = new CompositeDataSupport(_loggerLevelCompositeType, COMPOSITE_ITEM_NAMES, itemData);
                loggerLevelList.put(loggerData);
                continue;
            }
            catch (OpenDataException e) {
                _logger.warn((Object)("Unable to create logger level list due to :" + e));
                return null;
            }
        }
        return loggerLevelList;
    }

    public synchronized boolean setConfigFileLoggerLevel(String logger, String level) throws IOException {
        int i;
        try {
            this.getLevel(level);
        }
        catch (Exception e) {
            return false;
        }
        _logger.info((Object)("Setting level to " + level + " for logger '" + logger + "' in log4j xml configuration file: " + this._log4jConfigFileName));
        Document doc = this.parseConfigFile(this._log4jConfigFileName);
        NodeList categoryElements = doc.getElementsByTagName("category");
        NodeList loggerElements = doc.getElementsByTagName("logger");
        ArrayList<Element> logElements = new ArrayList<Element>();
        for (i = 0; i < categoryElements.getLength(); ++i) {
            logElements.add((Element)categoryElements.item(i));
        }
        for (i = 0; i < loggerElements.getLength(); ++i) {
            logElements.add((Element)loggerElements.item(i));
        }
        Element logElement = null;
        for (Element e : logElements) {
            if (!e.getAttribute("name").equals(logger)) continue;
            logElement = e;
            break;
        }
        if (logElement == null) {
            _logger.warn((Object)("Specified logger does not exist in the configuration file: " + logger));
            return false;
        }
        NodeList priorityElements = logElement.getElementsByTagName("priority");
        NodeList levelElements = logElement.getElementsByTagName("level");
        Element levelElement = null;
        if (priorityElements.getLength() != 0) {
            levelElement = (Element)priorityElements.item(0);
        } else if (levelElements.getLength() != 0) {
            levelElement = (Element)levelElements.item(0);
        } else {
            return false;
        }
        levelElement.setAttribute("value", level);
        return this.writeUpdatedConfigFile(this._log4jConfigFileName, doc);
    }

    public synchronized String getConfigFileRootLoggerLevel() throws IOException {
        _logger.info((Object)"Getting root logger level from log4j configuration file");
        Document doc = this.parseConfigFile(this._log4jConfigFileName);
        NodeList rootElements = doc.getElementsByTagName("root");
        if (rootElements.getLength() == 0) {
            return null;
        }
        Element rootElement = (Element)rootElements.item(0);
        NodeList priorityElements = rootElement.getElementsByTagName("priority");
        NodeList levelElements = rootElement.getElementsByTagName("level");
        String priority = null;
        if (priorityElements.getLength() != 0) {
            Element priorityElement = (Element)priorityElements.item(0);
            priority = priorityElement.getAttribute("value");
        } else if (levelElements.getLength() != 0) {
            Element levelElement = (Element)levelElements.item(0);
            priority = levelElement.getAttribute("value");
        }
        if (priority != null) {
            return priority.toUpperCase();
        }
        return null;
    }

    public synchronized boolean setConfigFileRootLoggerLevel(String level) throws IOException {
        try {
            this.getLevel(level);
        }
        catch (Exception e) {
            return false;
        }
        _logger.info((Object)("Setting level to " + level + " for the Root logger in " + "log4j xml configuration file: " + this._log4jConfigFileName));
        Document doc = this.parseConfigFile(this._log4jConfigFileName);
        NodeList rootElements = doc.getElementsByTagName("root");
        if (rootElements.getLength() == 0) {
            return false;
        }
        Element rootElement = (Element)rootElements.item(0);
        NodeList priorityElements = rootElement.getElementsByTagName("priority");
        NodeList levelElements = rootElement.getElementsByTagName("level");
        Element levelElement = null;
        if (priorityElements.getLength() != 0) {
            levelElement = (Element)priorityElements.item(0);
        } else if (levelElements.getLength() != 0) {
            levelElement = (Element)levelElements.item(0);
        } else {
            return false;
        }
        levelElement.setAttribute("value", level);
        return this.writeUpdatedConfigFile(this._log4jConfigFileName, doc);
    }

    static {
        try {
            OpenType[] loggerLevelItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
            _loggerLevelCompositeType = new CompositeType("LoggerLevelList", "Logger Level Data", COMPOSITE_ITEM_NAMES, COMPOSITE_ITEM_DESCRIPTIONS, loggerLevelItemTypes);
            _loggerLevelTabularType = new TabularType("LoggerLevel", "List of loggers with levels", _loggerLevelCompositeType, TABULAR_UNIQUE_INDEX);
        }
        catch (OpenDataException e) {
            _logger.error((Object)"Tabular data setup for viewing logger levels was incorrect.");
            _loggerLevelTabularType = null;
        }
    }

    private class SaxErrorHandler
    implements ErrorHandler {
        private SaxErrorHandler() {
        }

        public void error(SAXParseException e) throws SAXException {
            throw new SAXException("Error parsing XML file: " + e.getMessage());
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException("Fatal error parsing XML file: " + e.getMessage());
        }

        public void warning(SAXParseException e) throws SAXException {
            throw new SAXException("Warning parsing XML file: " + e.getMessage());
        }
    }
}

