/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.management.MBeanInvocationHandlerImpl;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.management.ManagedObjectRegistry;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.rmi.RMIPasswordAuthenticator;

public class JMXManagedObjectRegistry
implements ManagedObjectRegistry {
    private static final Logger _log = Logger.getLogger(JMXManagedObjectRegistry.class);
    private static final Logger _startupLog = Logger.getLogger((String)"Qpid.Broker");
    public static final String MANAGEMENT_PORT_CONFIG_PATH = "management.jmxport";
    public static final int MANAGEMENT_PORT_DEFAULT = 8999;
    public static final int PORT_EXPORT_OFFSET = 100;
    private final MBeanServer _mbeanServer;
    private Registry _rmiRegistry;

    public JMXManagedObjectRegistry() throws AMQException {
        _log.info((Object)"Initialising managed object registry using platform MBean server");
        IApplicationRegistry appRegistry = ApplicationRegistry.getInstance();
        boolean platformServer = appRegistry.getConfiguration().getPlatformMbeanserver();
        this._mbeanServer = platformServer ? ManagementFactory.getPlatformMBeanServer() : MBeanServerFactory.createMBeanServer("org.apache.qpid");
    }

    public void start() throws IOException, ConfigurationException {
        SslRMIServerSocketFactory ssf;
        SslRMIClientSocketFactory csf;
        if (this.areOutOfTheBoxJMXOptionsSet()) {
            _log.warn((Object)"JMX: Using the out of the box JMX Agent");
            _startupLog.warn((Object)"JMX: Using the out of the box JMX Agent");
            return;
        }
        IApplicationRegistry appRegistry = ApplicationRegistry.getInstance();
        int port = appRegistry.getConfiguration().getJMXManagementPort();
        String jmxDatabaseName = appRegistry.getConfiguration().getJMXPrincipalDatabase();
        Map<String, PrincipalDatabase> map = appRegistry.getDatabaseManager().getDatabases();
        PrincipalDatabase db = map.get(jmxDatabaseName);
        HashMap<String, RMIPasswordAuthenticator> env = new HashMap<String, RMIPasswordAuthenticator>();
        boolean sslEnabled = appRegistry.getConfiguration().getManagementSSLEnabled();
        if (sslEnabled) {
            String keyStorePath = System.getProperty("javax.net.ssl.keyStore") != null ? System.getProperty("javax.net.ssl.keyStore") : appRegistry.getConfiguration().getManagementKeyStorePath();
            if (keyStorePath == null) {
                throw new ConfigurationException("JMX management SSL keystore path not defined, unable to start SSL protected JMX ConnectorServer");
            }
            System.setProperty("javax.net.ssl.keyStore", keyStorePath);
            File ksf = new File(keyStorePath);
            if (!ksf.exists()) {
                throw new FileNotFoundException("Cannot find JMX management SSL keystore file " + ksf + "\n" + "Check broker configuration, or see create-example-ssl-stores script" + "in the bin/ directory if you need to generate an example store.");
            }
            if (!ksf.canRead()) {
                throw new FileNotFoundException("Cannot read JMX management SSL keystore file: " + ksf + ". Check permissions.");
            }
            _log.info((Object)("JMX ConnectorServer using SSL keystore file " + ksf.getAbsolutePath()));
            _startupLog.info((Object)("JMX ConnectorServer using SSL keystore file " + ksf.getAbsolutePath()));
            if (System.getProperty("javax.net.ssl.keyStorePassword") == null) {
                if (appRegistry.getConfiguration().getManagementKeyStorePassword() == null) {
                    throw new ConfigurationException("JMX management SSL keystore password not defined, unable to start requested SSL protected JMX server");
                }
                System.setProperty("javax.net.ssl.keyStorePassword", appRegistry.getConfiguration().getManagementKeyStorePassword());
            }
            csf = new SslRMIClientSocketFactory();
            ssf = new SslRMIServerSocketFactory();
            _log.warn((Object)("Starting JMX ConnectorServer on port '" + port + "' (+" + (port + 100) + ") with SSL"));
            _startupLog.warn((Object)("Starting JMX ConnectorServer on port '" + port + "' (+" + (port + 100) + ") with SSL"));
        } else {
            csf = null;
            ssf = null;
            _log.warn((Object)("Starting JMX ConnectorServer on port '" + port + "' (+" + (port + 100) + ")"));
            _startupLog.warn((Object)("Starting JMX ConnectorServer on port '" + port + "' (+" + (port + 100) + ")"));
        }
        RMIPasswordAuthenticator rmipa = new RMIPasswordAuthenticator();
        rmipa.setPrincipalDatabase(db);
        env.put("jmx.remote.authenticator", rmipa);
        System.setProperty("java.rmi.server.randomIDs", "true");
        this._rmiRegistry = LocateRegistry.createRegistry(port, null, new CustomRMIServerSocketFactory());
        final RMIJRMPServerImpl rmiConnectorServerStub = new RMIJRMPServerImpl(port + 100, csf, ssf, env);
        String hostname = InetAddress.getLocalHost().getHostName();
        final JMXServiceURL externalUrl = new JMXServiceURL("service:jmx:rmi://" + hostname + ":" + (port + 100) + "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi");
        JMXServiceURL internalUrl = new JMXServiceURL("rmi", hostname, port + 100);
        RMIConnectorServer cs = new RMIConnectorServer(internalUrl, env, rmiConnectorServerStub, this._mbeanServer){

            public synchronized void start() throws IOException {
                try {
                    JMXManagedObjectRegistry.this._rmiRegistry.bind("jmxrmi", rmiConnectorServerStub);
                }
                catch (AlreadyBoundException abe) {
                    IOException ioe = new IOException(abe.getMessage());
                    ioe.initCause(abe);
                    throw ioe;
                }
                super.start();
            }

            public JMXServiceURL getAddress() {
                return externalUrl;
            }
        };
        MBeanServerForwarder mbsf = MBeanInvocationHandlerImpl.newProxyInstance();
        ((JMXConnectorServer)cs).setMBeanServerForwarder(mbsf);
        cs.start();
    }

    public void registerObject(ManagedObject managedObject) throws JMException {
        this._mbeanServer.registerMBean(managedObject, managedObject.getObjectName());
    }

    public void unregisterObject(ManagedObject managedObject) throws JMException {
        this._mbeanServer.unregisterMBean(managedObject.getObjectName());
    }

    private boolean areOutOfTheBoxJMXOptionsSet() {
        if (System.getProperty("com.sun.management.jmxremote") != null) {
            return true;
        }
        return System.getProperty("com.sun.management.jmxremote.port") != null;
    }

    public void close() throws RemoteException {
        if (this._rmiRegistry != null) {
            UnicastRemoteObject.unexportObject(this._rmiRegistry, true);
        }
        ObjectName mbeanNameQuery = null;
        try {
            mbeanNameQuery = new ObjectName("org.apache.qpid:*");
        }
        catch (Exception e1) {
            _log.warn((Object)"Unable to generate MBean ObjectName query for close operation");
        }
        for (ObjectName name : this._mbeanServer.queryNames(mbeanNameQuery, null)) {
            try {
                this._mbeanServer.unregisterMBean(name);
            }
            catch (JMException e) {
                _log.error((Object)("Exception unregistering MBean '" + name + "': " + e.getMessage()));
            }
        }
    }

    private class CustomRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private CustomRMIServerSocketFactory() {
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            return new NoLocalAddressServerSocket(port);
        }

        private class NoLocalAddressSocket
        extends Socket {
            private NoLocalAddressSocket() {
            }

            public InetAddress getInetAddress() {
                return null;
            }
        }

        private class NoLocalAddressServerSocket
        extends ServerSocket {
            NoLocalAddressServerSocket(int port) throws IOException {
                super(port);
            }

            public Socket accept() throws IOException {
                NoLocalAddressSocket s = new NoLocalAddressSocket();
                super.implAccept(s);
                return s;
            }
        }
    }
}

