/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.MBeanServerForwarder;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class MBeanInvocationHandlerImpl
implements InvocationHandler {
    private static final Logger _logger = Logger.getLogger(MBeanInvocationHandlerImpl.class);
    public static final String ADMIN = "admin";
    public static final String READWRITE = "readwrite";
    public static final String READONLY = "readonly";
    private static final String DELEGATE = "JMImplementation:type=MBeanServerDelegate";
    private MBeanServer _mbs;
    private static Properties _userRoles = new Properties();
    private static HashSet<String> _adminOnlyMethods = new HashSet();

    public MBeanInvocationHandlerImpl() {
        _adminOnlyMethods.add("UserManagement");
        _adminOnlyMethods.add("LoggingManagement");
        _adminOnlyMethods.add("ConfigurationManagement");
    }

    public static MBeanServerForwarder newProxyInstance() {
        MBeanInvocationHandlerImpl handler = new MBeanInvocationHandlerImpl();
        Class[] interfaces = new Class[]{MBeanServerForwarder.class};
        Object proxy = Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), interfaces, (InvocationHandler)handler);
        return (MBeanServerForwarder)MBeanServerForwarder.class.cast(proxy);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("getMBeanServer")) {
            return this._mbs;
        }
        if (methodName.equals("setMBeanServer")) {
            if (args[0] == null) {
                throw new IllegalArgumentException("Null MBeanServer");
            }
            if (this._mbs != null) {
                throw new IllegalArgumentException("MBeanServer object already initialized");
            }
            this._mbs = (MBeanServer)args[0];
            return null;
        }
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            return method.invoke((Object)this._mbs, args);
        }
        if (args == null || DELEGATE.equals(args[0])) {
            return method.invoke((Object)this._mbs, args);
        }
        if (methodName.equals("createMBean") || methodName.equals("unregisterMBean")) {
            _logger.debug((Object)"User trying to create or unregister an MBean");
            throw new SecurityException("Access denied");
        }
        Set<JMXPrincipal> principals = subject.getPrincipals(JMXPrincipal.class);
        if (principals == null || principals.isEmpty()) {
            throw new SecurityException("Access denied");
        }
        Principal principal = principals.iterator().next();
        String identity = principal.getName();
        if (this.isAdminMethod(args)) {
            if (this.isAdmin(identity)) {
                return method.invoke((Object)this._mbs, args);
            }
            throw new SecurityException("Access denied");
        }
        if (this.isAllowedToModify(identity)) {
            return method.invoke((Object)this._mbs, args);
        }
        if (this.isReadOnlyUser(identity) && this.isReadOnlyMethod(method, args)) {
            return method.invoke((Object)this._mbs, args);
        }
        throw new SecurityException("Access denied");
    }

    private boolean isAdminMethod(Object[] args) {
        if (args[0] instanceof ObjectName) {
            ObjectName object = (ObjectName)args[0];
            return _adminOnlyMethods.contains(object.getKeyProperty("type"));
        }
        return false;
    }

    public static void setAccessRights(Properties accessRights) {
        _userRoles = accessRights;
    }

    private boolean isAdmin(String userName) {
        return ADMIN.equals(_userRoles.getProperty(userName));
    }

    private boolean isAllowedToModify(String userName) {
        return ADMIN.equals(_userRoles.getProperty(userName)) || READWRITE.equals(_userRoles.getProperty(userName));
    }

    private boolean isReadOnlyUser(String userName) {
        return READONLY.equals(_userRoles.getProperty(userName));
    }

    private boolean isReadOnlyMethod(Method method, Object[] args) {
        String methodName = method.getName();
        if (methodName.startsWith("query") || methodName.startsWith("get") || methodName.startsWith("isInstanceOf") || methodName.startsWith("isRegistered")) {
            return true;
        }
        if (methodName.startsWith("set")) {
            return false;
        }
        if (args[0] instanceof ObjectName && methodName.equals("invoke")) {
            String mbeanMethod;
            String string = mbeanMethod = args.length > 1 ? (String)args[1] : null;
            if (mbeanMethod == null) {
                return false;
            }
            try {
                MBeanInfo mbeanInfo = this._mbs.getMBeanInfo((ObjectName)args[0]);
                if (mbeanInfo != null) {
                    MBeanOperationInfo[] opInfos;
                    for (MBeanOperationInfo opInfo : opInfos = mbeanInfo.getOperations()) {
                        if (!opInfo.getName().equals(mbeanMethod) || opInfo.getImpact() != 0) continue;
                        return true;
                    }
                }
            }
            catch (JMException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }
}

