/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.output;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.server.output.ProtocolOutputConverter;
import org.apache.qpid.server.output.amqp0_8.ProtocolOutputConverterImpl;
import org.apache.qpid.server.protocol.AMQProtocolSession;

public class ProtocolOutputConverterRegistry {
    private static final Map<ProtocolVersion, ProtocolOutputConverter.Factory> _registry = new HashMap<ProtocolVersion, ProtocolOutputConverter.Factory>();

    private static void register(ProtocolVersion version, ProtocolOutputConverter.Factory converter) {
        _registry.put(version, converter);
    }

    public static ProtocolOutputConverter getConverter(AMQProtocolSession session) {
        return _registry.get(session.getProtocolVersion()).newInstance(session);
    }

    static {
        ProtocolOutputConverterRegistry.register(ProtocolVersion.v8_0, ProtocolOutputConverterImpl.getInstanceFactory());
        ProtocolOutputConverterRegistry.register(ProtocolVersion.v0_9, org.apache.qpid.server.output.amqp0_9.ProtocolOutputConverterImpl.getInstanceFactory());
    }
}

