/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.output.amqp0_8;

import java.util.Iterator;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.CompositeAMQDataBlock;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.SmallCompositeAMQDataBlock;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.output.ProtocolOutputConverter;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.AMQMessageHandle;
import org.apache.qpid.server.store.StoreContext;

public class ProtocolOutputConverterImpl
implements ProtocolOutputConverter {
    private final AMQProtocolSession _protocolSession;

    public static ProtocolOutputConverter.Factory getInstanceFactory() {
        return new ProtocolOutputConverter.Factory(){

            public ProtocolOutputConverter newInstance(AMQProtocolSession session) {
                return new ProtocolOutputConverterImpl(session);
            }
        };
    }

    private ProtocolOutputConverterImpl(AMQProtocolSession session) {
        this._protocolSession = session;
    }

    public AMQProtocolSession getProtocolSession() {
        return this._protocolSession;
    }

    public void writeDeliver(AMQMessage message, int channelId, long deliveryTag, AMQShortString consumerTag) throws AMQException {
        StoreContext storeContext;
        AMQDataBlock deliver = this.createEncodedDeliverFrame(message, channelId, deliveryTag, consumerTag);
        AMQFrame contentHeader = ContentHeaderBody.createAMQFrame((int)channelId, (ContentHeaderBody)message.getContentHeaderBody());
        AMQMessageHandle messageHandle = message.getMessageHandle();
        int bodyCount = messageHandle.getBodyCount(storeContext = message.getStoreContext());
        if (bodyCount == 0) {
            SmallCompositeAMQDataBlock compositeBlock = new SmallCompositeAMQDataBlock(deliver, (AMQDataBlock)contentHeader);
            this.writeFrame((AMQDataBlock)compositeBlock);
        } else {
            ContentChunk cb = messageHandle.getContentChunk(storeContext, 0);
            AMQFrame firstContentBody = new AMQFrame(channelId, this.getProtocolSession().getMethodRegistry().getProtocolVersionMethodConverter().convertToBody(cb));
            AMQDataBlock[] blocks = new AMQDataBlock[]{deliver, contentHeader, firstContentBody};
            CompositeAMQDataBlock compositeBlock = new CompositeAMQDataBlock(blocks);
            this.writeFrame((AMQDataBlock)compositeBlock);
            for (int i = 1; i < bodyCount; ++i) {
                cb = messageHandle.getContentChunk(storeContext, i);
                this.writeFrame((AMQDataBlock)new AMQFrame(channelId, this.getProtocolSession().getMethodRegistry().getProtocolVersionMethodConverter().convertToBody(cb)));
            }
        }
    }

    public void writeGetOk(AMQMessage message, int channelId, long deliveryTag, int queueSize) throws AMQException {
        AMQMessageHandle messageHandle = message.getMessageHandle();
        StoreContext storeContext = message.getStoreContext();
        AMQDataBlock deliver = this.createEncodedGetOkFrame(message, channelId, deliveryTag, queueSize);
        AMQFrame contentHeader = ContentHeaderBody.createAMQFrame((int)channelId, (ContentHeaderBody)message.getContentHeaderBody());
        int bodyCount = messageHandle.getBodyCount(storeContext);
        if (bodyCount == 0) {
            SmallCompositeAMQDataBlock compositeBlock = new SmallCompositeAMQDataBlock(deliver, (AMQDataBlock)contentHeader);
            this.writeFrame((AMQDataBlock)compositeBlock);
        } else {
            ContentChunk cb = messageHandle.getContentChunk(storeContext, 0);
            AMQFrame firstContentBody = new AMQFrame(channelId, this.getProtocolSession().getMethodRegistry().getProtocolVersionMethodConverter().convertToBody(cb));
            AMQDataBlock[] blocks = new AMQDataBlock[]{deliver, contentHeader, firstContentBody};
            CompositeAMQDataBlock compositeBlock = new CompositeAMQDataBlock(blocks);
            this.writeFrame((AMQDataBlock)compositeBlock);
            for (int i = 1; i < bodyCount; ++i) {
                cb = messageHandle.getContentChunk(storeContext, i);
                this.writeFrame((AMQDataBlock)new AMQFrame(channelId, this.getProtocolSession().getMethodRegistry().getProtocolVersionMethodConverter().convertToBody(cb)));
            }
        }
    }

    private AMQDataBlock createEncodedDeliverFrame(AMQMessage message, int channelId, long deliveryTag, AMQShortString consumerTag) throws AMQException {
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQMessageHandle messageHandle = message.getMessageHandle();
        MethodRegistry methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)ProtocolVersion.v8_0);
        BasicDeliverBody deliverBody = methodRegistry.createBasicDeliverBody(consumerTag, deliveryTag, messageHandle.isRedelivered(), pb.getExchange(), pb.getRoutingKey());
        AMQFrame deliverFrame = deliverBody.generateFrame(channelId);
        return deliverFrame;
    }

    private AMQDataBlock createEncodedGetOkFrame(AMQMessage message, int channelId, long deliveryTag, int queueSize) throws AMQException {
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQMessageHandle messageHandle = message.getMessageHandle();
        MethodRegistry methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)ProtocolVersion.v8_0);
        BasicGetOkBody getOkBody = methodRegistry.createBasicGetOkBody(deliveryTag, messageHandle.isRedelivered(), pb.getExchange(), pb.getRoutingKey(), (long)queueSize);
        AMQFrame getOkFrame = getOkBody.generateFrame(channelId);
        return getOkFrame;
    }

    public byte getProtocolMinorVersion() {
        return this.getProtocolSession().getProtocolMinorVersion();
    }

    public byte getProtocolMajorVersion() {
        return this.getProtocolSession().getProtocolMajorVersion();
    }

    private AMQDataBlock createEncodedReturnFrame(AMQMessage message, int channelId, int replyCode, AMQShortString replyText) throws AMQException {
        MethodRegistry methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)ProtocolVersion.v8_0);
        BasicReturnBody basicReturnBody = methodRegistry.createBasicReturnBody(replyCode, replyText, message.getMessagePublishInfo().getExchange(), message.getMessagePublishInfo().getRoutingKey());
        AMQFrame returnFrame = basicReturnBody.generateFrame(channelId);
        return returnFrame;
    }

    public void writeReturn(AMQMessage message, int channelId, int replyCode, AMQShortString replyText) throws AMQException {
        AMQDataBlock returnFrame = this.createEncodedReturnFrame(message, channelId, replyCode, replyText);
        AMQFrame contentHeader = ContentHeaderBody.createAMQFrame((int)channelId, (ContentHeaderBody)message.getContentHeaderBody());
        Iterator<AMQDataBlock> bodyFrameIterator = message.getBodyFrameIterator(this.getProtocolSession(), channelId);
        if (bodyFrameIterator.hasNext()) {
            AMQDataBlock firstContentBody = bodyFrameIterator.next();
            AMQDataBlock[] blocks = new AMQDataBlock[]{returnFrame, contentHeader, firstContentBody};
            CompositeAMQDataBlock compositeBlock = new CompositeAMQDataBlock(blocks);
            this.writeFrame((AMQDataBlock)compositeBlock);
        } else {
            CompositeAMQDataBlock compositeBlock = new CompositeAMQDataBlock(new AMQDataBlock[]{returnFrame, contentHeader});
            this.writeFrame((AMQDataBlock)compositeBlock);
        }
        while (bodyFrameIterator.hasNext()) {
            this.writeFrame(bodyFrameIterator.next());
        }
    }

    public void writeFrame(AMQDataBlock block) {
        this.getProtocolSession().writeFrame(block);
    }

    public void confirmConsumerAutoClose(int channelId, AMQShortString consumerTag) {
        MethodRegistry methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)ProtocolVersion.v8_0);
        BasicCancelOkBody basicCancelOkBody = methodRegistry.createBasicCancelOkBody(consumerTag);
        this.writeFrame((AMQDataBlock)basicCancelOkBody.generateFrame(channelId));
    }
}

