/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.output.amqp0_9;

import java.util.Iterator;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.CompositeAMQDataBlock;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.SmallCompositeAMQDataBlock;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.framing.abstraction.ProtocolVersionMethodConverter;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.output.ProtocolOutputConverter;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.AMQMessageHandle;
import org.apache.qpid.server.store.StoreContext;

public class ProtocolOutputConverterImpl
implements ProtocolOutputConverter {
    private static final MethodRegistry METHOD_REGISTRY = MethodRegistry.getMethodRegistry((ProtocolVersion)ProtocolVersion.v0_9);
    private static final ProtocolVersionMethodConverter PROTOCOL_METHOD_CONVERTER = METHOD_REGISTRY.getProtocolVersionMethodConverter();
    private final AMQProtocolSession _protocolSession;

    public static ProtocolOutputConverter.Factory getInstanceFactory() {
        return new ProtocolOutputConverter.Factory(){

            public ProtocolOutputConverter newInstance(AMQProtocolSession session) {
                return new ProtocolOutputConverterImpl(session);
            }
        };
    }

    private ProtocolOutputConverterImpl(AMQProtocolSession session) {
        this._protocolSession = session;
    }

    public AMQProtocolSession getProtocolSession() {
        return this._protocolSession;
    }

    public void writeDeliver(AMQMessage message, int channelId, long deliveryTag, AMQShortString consumerTag) throws AMQException {
        StoreContext storeContext;
        AMQBody deliverBody = this.createEncodedDeliverFrame(message, channelId, deliveryTag, consumerTag);
        ContentHeaderBody contentHeaderBody = message.getContentHeaderBody();
        AMQMessageHandle messageHandle = message.getMessageHandle();
        int bodyCount = messageHandle.getBodyCount(storeContext = message.getStoreContext());
        if (bodyCount == 0) {
            SmallCompositeAMQBodyBlock compositeBlock = new SmallCompositeAMQBodyBlock(channelId, deliverBody, (AMQBody)contentHeaderBody);
            this.writeFrame(compositeBlock);
        } else {
            ContentChunk cb = messageHandle.getContentChunk(storeContext, 0);
            AMQBody firstContentBody = PROTOCOL_METHOD_CONVERTER.convertToBody(cb);
            CompositeAMQBodyBlock compositeBlock = new CompositeAMQBodyBlock(channelId, deliverBody, (AMQBody)contentHeaderBody, firstContentBody);
            this.writeFrame(compositeBlock);
            for (int i = 1; i < bodyCount; ++i) {
                cb = messageHandle.getContentChunk(storeContext, i);
                this.writeFrame((AMQDataBlock)new AMQFrame(channelId, PROTOCOL_METHOD_CONVERTER.convertToBody(cb)));
            }
        }
    }

    private AMQDataBlock createContentHeaderBlock(int channelId, ContentHeaderBody contentHeaderBody) {
        AMQFrame contentHeader = ContentHeaderBody.createAMQFrame((int)channelId, (ContentHeaderBody)contentHeaderBody);
        return contentHeader;
    }

    public void writeGetOk(AMQMessage message, int channelId, long deliveryTag, int queueSize) throws AMQException {
        AMQMessageHandle messageHandle = message.getMessageHandle();
        StoreContext storeContext = message.getStoreContext();
        AMQFrame deliver = this.createEncodedGetOkFrame(message, channelId, deliveryTag, queueSize);
        AMQDataBlock contentHeader = this.createContentHeaderBlock(channelId, message.getContentHeaderBody());
        int bodyCount = messageHandle.getBodyCount(storeContext);
        if (bodyCount == 0) {
            SmallCompositeAMQDataBlock compositeBlock = new SmallCompositeAMQDataBlock((AMQDataBlock)deliver, contentHeader);
            this.writeFrame((AMQDataBlock)compositeBlock);
        } else {
            ContentChunk cb = messageHandle.getContentChunk(storeContext, 0);
            AMQFrame firstContentBody = new AMQFrame(channelId, PROTOCOL_METHOD_CONVERTER.convertToBody(cb));
            AMQDataBlock[] blocks = new AMQDataBlock[]{deliver, contentHeader, firstContentBody};
            CompositeAMQDataBlock compositeBlock = new CompositeAMQDataBlock(blocks);
            this.writeFrame((AMQDataBlock)compositeBlock);
            for (int i = 1; i < bodyCount; ++i) {
                cb = messageHandle.getContentChunk(storeContext, i);
                this.writeFrame((AMQDataBlock)new AMQFrame(channelId, PROTOCOL_METHOD_CONVERTER.convertToBody(cb)));
            }
        }
    }

    private AMQBody createEncodedDeliverFrame(AMQMessage message, int channelId, final long deliveryTag, final AMQShortString consumerTag) throws AMQException {
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQMessageHandle messageHandle = message.getMessageHandle();
        final boolean isRedelivered = messageHandle.isRedelivered();
        final AMQShortString exchangeName = pb.getExchange();
        final AMQShortString routingKey = pb.getRoutingKey();
        AMQBody returnBlock = new AMQBody(){
            public AMQBody _underlyingBody;

            public AMQBody createAMQBody() {
                return METHOD_REGISTRY.createBasicDeliverBody(consumerTag, deliveryTag, isRedelivered, exchangeName, routingKey);
            }

            public byte getFrameType() {
                return 1;
            }

            public int getSize() {
                if (this._underlyingBody == null) {
                    this._underlyingBody = this.createAMQBody();
                }
                return this._underlyingBody.getSize();
            }

            public void writePayload(ByteBuffer buffer) {
                if (this._underlyingBody == null) {
                    this._underlyingBody = this.createAMQBody();
                }
                this._underlyingBody.writePayload(buffer);
            }

            public void handle(int channelId, AMQVersionAwareProtocolSession amqMinaProtocolSession) throws AMQException {
                throw new AMQException("This block should never be dispatched!");
            }
        };
        return returnBlock;
    }

    private AMQFrame createEncodedGetOkFrame(AMQMessage message, int channelId, long deliveryTag, int queueSize) throws AMQException {
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQMessageHandle messageHandle = message.getMessageHandle();
        BasicGetOkBody getOkBody = METHOD_REGISTRY.createBasicGetOkBody(deliveryTag, messageHandle.isRedelivered(), pb.getExchange(), pb.getRoutingKey(), (long)queueSize);
        AMQFrame getOkFrame = getOkBody.generateFrame(channelId);
        return getOkFrame;
    }

    public byte getProtocolMinorVersion() {
        return this.getProtocolSession().getProtocolMinorVersion();
    }

    public byte getProtocolMajorVersion() {
        return this.getProtocolSession().getProtocolMajorVersion();
    }

    private AMQDataBlock createEncodedReturnFrame(AMQMessage message, int channelId, int replyCode, AMQShortString replyText) throws AMQException {
        BasicReturnBody basicReturnBody = METHOD_REGISTRY.createBasicReturnBody(replyCode, replyText, message.getMessagePublishInfo().getExchange(), message.getMessagePublishInfo().getRoutingKey());
        AMQFrame returnFrame = basicReturnBody.generateFrame(channelId);
        return returnFrame;
    }

    public void writeReturn(AMQMessage message, int channelId, int replyCode, AMQShortString replyText) throws AMQException {
        AMQDataBlock returnFrame = this.createEncodedReturnFrame(message, channelId, replyCode, replyText);
        AMQDataBlock contentHeader = this.createContentHeaderBlock(channelId, message.getContentHeaderBody());
        Iterator<AMQDataBlock> bodyFrameIterator = message.getBodyFrameIterator(this.getProtocolSession(), channelId);
        if (bodyFrameIterator.hasNext()) {
            AMQDataBlock firstContentBody = bodyFrameIterator.next();
            AMQDataBlock[] blocks = new AMQDataBlock[]{returnFrame, contentHeader, firstContentBody};
            CompositeAMQDataBlock compositeBlock = new CompositeAMQDataBlock(blocks);
            this.writeFrame((AMQDataBlock)compositeBlock);
        } else {
            CompositeAMQDataBlock compositeBlock = new CompositeAMQDataBlock(new AMQDataBlock[]{returnFrame, contentHeader});
            this.writeFrame((AMQDataBlock)compositeBlock);
        }
        while (bodyFrameIterator.hasNext()) {
            this.writeFrame(bodyFrameIterator.next());
        }
    }

    public void writeFrame(AMQDataBlock block) {
        this.getProtocolSession().writeFrame(block);
    }

    public void confirmConsumerAutoClose(int channelId, AMQShortString consumerTag) {
        BasicCancelOkBody basicCancelOkBody = METHOD_REGISTRY.createBasicCancelOkBody(consumerTag);
        this.writeFrame((AMQDataBlock)basicCancelOkBody.generateFrame(channelId));
    }

    public static final class SmallCompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 2 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final int _channel;

        public SmallCompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
        }

        public long getSize() {
            return OVERHEAD + this._methodBody.getSize() + this._headerBody.getSize();
        }

        public void writePayload(ByteBuffer buffer) {
            AMQFrame.writeFrames((ByteBuffer)buffer, (int)this._channel, (AMQBody)this._methodBody, (AMQBody)this._headerBody);
        }
    }

    public static final class CompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 3 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final AMQBody _contentBody;
        private final int _channel;

        public CompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody, AMQBody contentBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
            this._contentBody = contentBody;
        }

        public long getSize() {
            return OVERHEAD + this._methodBody.getSize() + this._headerBody.getSize() + this._contentBody.getSize();
        }

        public void writePayload(ByteBuffer buffer) {
            AMQFrame.writeFrames((ByteBuffer)buffer, (int)this._channel, (AMQBody)this._methodBody, (AMQBody)this._headerBody, (AMQBody)this._contentBody);
        }
    }
}

