/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.StringMap;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.plugins.Activator;
import org.apache.qpid.server.security.access.ACLPlugin;
import org.apache.qpid.server.security.access.ACLPluginFactory;
import org.apache.qpid.server.security.access.plugins.AllowAll;
import org.apache.qpid.server.security.access.plugins.DenyAll;
import org.apache.qpid.server.security.access.plugins.LegacyAccessPlugin;
import org.apache.qpid.server.security.access.plugins.SimpleXML;
import org.apache.qpid.server.security.access.plugins.network.FirewallPlugin;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    private Felix _felix = null;
    private ServiceTracker _exchangeTracker = null;
    private ServiceTracker _securityTracker = null;
    private Activator _activator = null;
    private boolean _empty;
    private Map<String, ACLPluginFactory> _securityPlugins;

    public PluginManager(String plugindir) throws Exception {
        StringMap configMap = new StringMap(false);
        configMap.put((Object)"felix.embedded.execution", (Object)"true");
        configMap.put((Object)"org.osgi.framework.system.packages", (Object)"org.osgi.framework; version=1.3.0,org.osgi.service.packageadmin; version=1.2.0,org.osgi.service.startlevel; version=1.0.0,org.osgi.service.url; version=1.0.0,org.apache.qpid.framing; version=0.2.1,org.apache.qpid.server.exchange; version=0.2.1,org.apache.qpid.server.management; version=0.2.1,org.apache.qpid.protocol; version=0.2.1,org.apache.qpid.server.virtualhost; version=0.2.1,org.apache.qpid; version=0.2.1,org.apache.qpid.server.queue; version=0.2.1,javax.management.openmbean; version=1.0.0,javax.management; version=1.0.0,org.apache.qpid.junit.extensions.util; version=0.6.1,");
        if (plugindir == null) {
            this._empty = true;
            return;
        }
        File dir = new File(plugindir);
        if (!dir.exists()) {
            this._empty = true;
            return;
        }
        StringBuffer pluginJars = new StringBuffer();
        if (dir.isDirectory()) {
            for (String child : dir.list()) {
                if (!child.endsWith("jar")) continue;
                pluginJars.append(String.format(" file:%s%s%s", plugindir, File.separator, child));
            }
        }
        if (pluginJars.length() == 0) {
            this._empty = true;
            return;
        }
        configMap.put((Object)"felix.auto.start.1", (Object)pluginJars.toString());
        configMap.put((Object)"felix.cache.profiledir", (Object)plugindir);
        ArrayList<Activator> activators = new ArrayList<Activator>();
        this._activator = new Activator();
        activators.add(this._activator);
        this._felix = new Felix((Map)configMap, activators);
        try {
            this._felix.start();
            this._exchangeTracker = new ServiceTracker(this._activator.getContext(), ExchangeType.class.getName(), null);
            this._exchangeTracker.open();
            this._securityTracker = new ServiceTracker(this._activator.getContext(), ACLPlugin.class.getName(), null);
            this._exchangeTracker.open();
        }
        catch (BundleException e) {
            throw new Exception("Could not create bundle");
        }
    }

    private <type> Map<String, type> getServices(ServiceTracker tracker) {
        HashMap<String, Object> exchanges = new HashMap<String, Object>();
        if (tracker != null) {
            for (Object service : tracker.getServices()) {
                exchanges.put(service.getClass().getName(), service);
            }
        }
        return exchanges;
    }

    public Map<String, ExchangeType<?>> getExchanges() {
        return this.getServices(this._exchangeTracker);
    }

    public Map<String, ACLPluginFactory> getSecurityPlugins() {
        if (this._securityPlugins == null) {
            this._securityPlugins = this.getServices(this._securityTracker);
            this._securityPlugins.put(SimpleXML.class.getName(), SimpleXML.FACTORY);
            this._securityPlugins.put(AllowAll.class.getName(), AllowAll.FACTORY);
            this._securityPlugins.put(DenyAll.class.getName(), DenyAll.FACTORY);
            this._securityPlugins.put(LegacyAccessPlugin.class.getName(), LegacyAccessPlugin.FACTORY);
            this._securityPlugins.put(FirewallPlugin.class.getName(), FirewallPlugin.FACTORY);
        }
        return this._securityPlugins;
    }
}

