/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.JMException;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.qpid.AMQChannelException;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.AMQCodecFactory;
import org.apache.qpid.codec.AMQDecoder;
import org.apache.qpid.common.ClientProperties;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.HeartbeatBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.pool.ReadWriteThreadModel;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.protocol.AMQMethodEvent;
import org.apache.qpid.protocol.AMQMethodListener;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.handler.ServerMethodDispatcherImpl;
import org.apache.qpid.server.management.Managable;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.output.ProtocolOutputConverter;
import org.apache.qpid.server.output.ProtocolOutputConverterRegistry;
import org.apache.qpid.server.protocol.AMQNoMethodHandlerException;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.protocol.AMQProtocolSessionMBean;
import org.apache.qpid.server.protocol.UnknnownMessageTypeException;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.state.AMQState;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;
import org.apache.qpid.transport.Sender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQMinaProtocolSession
implements AMQProtocolSession,
Managable {
    private static final Logger _logger = Logger.getLogger(AMQProtocolSession.class);
    private static final String CLIENT_PROPERTIES_INSTANCE = ClientProperties.instance.toString();
    private static final int CHANNEL_CACHE_SIZE = 255;
    private final IoSession _minaProtocolSession;
    private AMQShortString _contextKey;
    private AMQShortString _clientVersion = null;
    private VirtualHost _virtualHost;
    private final Map<Integer, AMQChannel> _channelMap = new HashMap<Integer, AMQChannel>();
    private final AMQChannel[] _cachedChannels = new AMQChannel[256];
    private final CopyOnWriteArraySet<AMQMethodListener> _frameListeners = new CopyOnWriteArraySet();
    private final AMQStateManager _stateManager;
    private AMQCodecFactory _codecFactory;
    private AMQProtocolSessionMBean _managedObject;
    private SaslServer _saslServer;
    private Object _lastReceived;
    private Object _lastSent;
    protected boolean _closed;
    private long _maxNoOfChannels = 1000L;
    private ProtocolVersion _protocolVersion = ProtocolVersion.getLatestSupportedVersion();
    private FieldTable _clientProperties;
    private final List<AMQProtocolSession.Task> _taskList = new CopyOnWriteArrayList<AMQProtocolSession.Task>();
    private List<Integer> _closingChannelsList = new CopyOnWriteArrayList<Integer>();
    private ProtocolOutputConverter _protocolOutputConverter;
    private Principal _authorizedID;
    private MethodDispatcher _dispatcher;
    private AMQProtocolSession.ProtocolSessionIdentifier _sessionIdentifier;
    private static final long LAST_WRITE_FUTURE_JOIN_TIMEOUT = 60000L;
    private WriteFuture _lastWriteFuture;

    @Override
    public ManagedObject getManagedObject() {
        return this._managedObject;
    }

    public AMQMinaProtocolSession(IoSession session, VirtualHostRegistry virtualHostRegistry, AMQCodecFactory codecFactory) throws AMQException {
        this._stateManager = new AMQStateManager(virtualHostRegistry, this);
        this._minaProtocolSession = session;
        session.setAttachment((Object)this);
        this._codecFactory = codecFactory;
        try {
            IoServiceConfig config = session.getServiceConfig();
            ReadWriteThreadModel threadModel = (ReadWriteThreadModel)config.getThreadModel();
            threadModel.getAsynchronousReadFilter().createNewJobForSession(session);
            threadModel.getAsynchronousWriteFilter().createNewJobForSession(session);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public AMQMinaProtocolSession(IoSession session, VirtualHostRegistry virtualHostRegistry, AMQCodecFactory codecFactory, AMQStateManager stateManager) throws AMQException {
        this._stateManager = stateManager;
        this._minaProtocolSession = session;
        session.setAttachment((Object)this);
        this._codecFactory = codecFactory;
    }

    private AMQProtocolSessionMBean createMBean() throws AMQException {
        try {
            return new AMQProtocolSessionMBean(this);
        }
        catch (JMException ex) {
            _logger.error((Object)"AMQProtocolSession MBean creation has failed ", (Throwable)ex);
            throw new AMQException("AMQProtocolSession MBean creation has failed ", (Throwable)ex);
        }
    }

    public IoSession getIOSession() {
        return this._minaProtocolSession;
    }

    public static AMQProtocolSession getAMQProtocolSession(IoSession minaProtocolSession) {
        return (AMQProtocolSession)minaProtocolSession.getAttachment();
    }

    @Override
    public void dataBlockReceived(AMQDataBlock message) throws Exception {
        this._lastReceived = message;
        if (message instanceof ProtocolInitiation) {
            this.protocolInitiationReceived((ProtocolInitiation)message);
        } else if (message instanceof AMQFrame) {
            AMQFrame frame = (AMQFrame)message;
            this.frameReceived(frame);
        } else {
            throw new UnknnownMessageTypeException(message);
        }
    }

    private void frameReceived(AMQFrame frame) throws AMQException {
        int channelId = frame.getChannel();
        AMQBody body = frame.getBodyFrame();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Frame Received: " + frame));
        }
        if (this.channelAwaitingClosure(channelId)) {
            if (frame.getBodyFrame() instanceof ChannelCloseOkBody) {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)("Channel[" + channelId + "] awaiting closure - processing close-ok"));
                }
            } else {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)("Channel[" + channelId + "] awaiting closure. Should close socket as client did not close-ok :" + frame));
                }
                this.closeProtocolSession();
                return;
            }
        }
        try {
            body.handle(channelId, (AMQVersionAwareProtocolSession)this);
        }
        catch (AMQException e) {
            this.closeChannel(channelId);
            throw e;
        }
    }

    private void protocolInitiationReceived(ProtocolInitiation pi) {
        ((AMQDecoder)this._codecFactory.getDecoder()).setExpectProtocolInitiation(false);
        try {
            ProtocolVersion pv = pi.checkVersion();
            this.setProtocolVersion(pv);
            String mechanisms = ApplicationRegistry.getInstance().getAuthenticationManager().getMechanisms();
            String locales = "en_US";
            ConnectionStartBody responseBody = this.getMethodRegistry().createConnectionStartBody((short)this.getProtocolMajorVersion(), (short)this.getProtocolMinorVersion(), null, mechanisms.getBytes(), locales.getBytes());
            this._minaProtocolSession.write((Object)responseBody.generateFrame(0));
        }
        catch (AMQException e) {
            _logger.info((Object)("Received unsupported protocol initiation for protocol version: " + this.getProtocolVersion()));
            this._minaProtocolSession.write((Object)new ProtocolInitiation(ProtocolVersion.getLatestSupportedVersion()));
        }
    }

    public void methodFrameReceived(int channelId, AMQMethodBody methodBody) {
        block13: {
            AMQMethodEvent evt = new AMQMethodEvent(channelId, methodBody);
            try {
                try {
                    boolean wasAnyoneInterested = this._stateManager.methodReceived(evt);
                    if (!this._frameListeners.isEmpty()) {
                        for (AMQMethodListener listener : this._frameListeners) {
                            wasAnyoneInterested = listener.methodReceived(evt) || wasAnyoneInterested;
                        }
                    }
                    if (!wasAnyoneInterested) {
                        throw new AMQNoMethodHandlerException((AMQMethodEvent<AMQMethodBody>)evt);
                    }
                }
                catch (AMQChannelException e) {
                    if (this.getChannel(channelId) != null) {
                        if (_logger.isInfoEnabled()) {
                            _logger.info((Object)("Closing channel due to: " + e.getMessage()));
                        }
                        this.writeFrame((AMQDataBlock)e.getCloseFrame(channelId));
                        this.closeChannel(channelId);
                        break block13;
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("ChannelException occured on non-existent channel:" + e.getMessage()));
                    }
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)("Closing connection due to: " + e.getMessage()));
                    }
                    AMQConnectionException ce = evt.getMethod().getConnectionException(AMQConstant.CHANNEL_ERROR, AMQConstant.CHANNEL_ERROR.getName().toString());
                    this.closeConnection(channelId, ce, false);
                }
                catch (AMQConnectionException e) {
                    this.closeConnection(channelId, e, false);
                }
            }
            catch (Exception e) {
                for (AMQMethodListener listener : this._frameListeners) {
                    listener.error(e);
                }
                _logger.error((Object)"Unexpected exception while processing frame.  Closing connection.", (Throwable)e);
                this.closeProtocolSession();
            }
        }
    }

    public void contentHeaderReceived(int channelId, ContentHeaderBody body) throws AMQException {
        AMQChannel channel = this.getAndAssertChannel(channelId);
        channel.publishContentHeader(body);
    }

    public void contentBodyReceived(int channelId, ContentBody body) throws AMQException {
        AMQChannel channel = this.getAndAssertChannel(channelId);
        channel.publishContentBody(body);
    }

    public void heartbeatBodyReceived(int channelId, HeartbeatBody body) {
    }

    public void writeFrame(AMQDataBlock frame) {
        this._lastSent = frame;
        this._lastWriteFuture = this._minaProtocolSession.write((Object)frame);
    }

    @Override
    public AMQShortString getContextKey() {
        return this._contextKey;
    }

    @Override
    public void setContextKey(AMQShortString contextKey) {
        this._contextKey = contextKey;
    }

    public List<AMQChannel> getChannels() {
        return new ArrayList<AMQChannel>(this._channelMap.values());
    }

    public AMQChannel getAndAssertChannel(int channelId) throws AMQException {
        AMQChannel channel = this.getChannel(channelId);
        if (channel == null) {
            throw new AMQException(AMQConstant.NOT_FOUND, "Channel not found with id:" + channelId);
        }
        return channel;
    }

    @Override
    public AMQChannel getChannel(int channelId) throws AMQException {
        AMQChannel channel;
        AMQChannel aMQChannel = channel = (channelId & 0xFF) == channelId ? this._cachedChannels[channelId] : this._channelMap.get(channelId);
        if (channel == null || channel.isClosing()) {
            return null;
        }
        return channel;
    }

    @Override
    public boolean channelAwaitingClosure(int channelId) {
        return !this._closingChannelsList.isEmpty() && this._closingChannelsList.contains(channelId);
    }

    @Override
    public void addChannel(AMQChannel channel) throws AMQException {
        if (this._closed) {
            throw new AMQException("Session is closed");
        }
        int channelId = channel.getChannelId();
        if (this._closingChannelsList.contains(channelId)) {
            throw new AMQException("Session is marked awaiting channel close");
        }
        if ((long)this._channelMap.size() == this._maxNoOfChannels) {
            String errorMessage = this.toString() + ": maximum number of channels has been reached (" + this._maxNoOfChannels + "); can't create channel";
            _logger.error((Object)errorMessage);
            throw new AMQException(AMQConstant.NOT_ALLOWED, errorMessage);
        }
        this._channelMap.put(channel.getChannelId(), channel);
        if ((channelId & 0xFF) == channelId) {
            this._cachedChannels[channelId] = channel;
        }
        this.checkForNotification();
    }

    private void checkForNotification() {
        int channelsCount = this._channelMap.size();
        if ((long)channelsCount >= this._maxNoOfChannels) {
            this._managedObject.notifyClients("Channel count (" + channelsCount + ") has reached the threshold value");
        }
    }

    public Long getMaximumNumberOfChannels() {
        return this._maxNoOfChannels;
    }

    public void setMaximumNumberOfChannels(Long value) {
        this._maxNoOfChannels = value;
    }

    public void commitTransactions(AMQChannel channel) throws AMQException {
        if (channel != null && channel.isTransactional()) {
            channel.commit();
        }
    }

    public void rollbackTransactions(AMQChannel channel) throws AMQException {
        if (channel != null && channel.isTransactional()) {
            channel.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeChannel(int channelId) throws AMQException {
        AMQChannel channel = this.getChannel(channelId);
        if (channel == null) {
            throw new IllegalArgumentException("Unknown channel id");
        }
        try {
            channel.close();
            this.markChannelAwaitingCloseOk(channelId);
        }
        finally {
            this.removeChannel(channelId);
        }
    }

    @Override
    public void closeChannelOk(int channelId) {
        this._closingChannelsList.remove(new Integer(channelId));
    }

    private void markChannelAwaitingCloseOk(int channelId) {
        this._closingChannelsList.add(channelId);
    }

    @Override
    public void removeChannel(int channelId) {
        this._channelMap.remove(channelId);
        if ((channelId & 0xFF) == channelId) {
            this._cachedChannels[channelId] = null;
        }
    }

    @Override
    public void initHeartbeats(int delay) {
        if (delay > 0) {
            this._minaProtocolSession.setIdleTime(IdleStatus.WRITER_IDLE, delay);
            this._minaProtocolSession.setIdleTime(IdleStatus.READER_IDLE, (int)(ApplicationRegistry.getInstance().getConfiguration().getHeartBeatTimeout() * (double)delay));
        }
    }

    private void closeAllChannels() throws AMQException {
        for (AMQChannel channel : this._channelMap.values()) {
            channel.close();
        }
        this._channelMap.clear();
        for (int i = 0; i <= 255; ++i) {
            this._cachedChannels[i] = null;
        }
    }

    @Override
    public void closeSession() throws AMQException {
        if (!this._closed) {
            this._closed = true;
            if (this._virtualHost != null) {
                this._virtualHost.getConnectionRegistry().deregisterConnection(this);
            }
            this.closeAllChannels();
            if (this._managedObject != null) {
                this._managedObject.unregister();
            }
            for (AMQProtocolSession.Task task : this._taskList) {
                task.doTask(this);
            }
        }
    }

    @Override
    public void closeConnection(int channelId, AMQConnectionException e, boolean closeProtocolSession) throws AMQException {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Closing connection due to: " + e.getMessage()));
        }
        this.markChannelAwaitingCloseOk(channelId);
        this.closeSession();
        this._stateManager.changeState(AMQState.CONNECTION_CLOSING);
        this.writeFrame((AMQDataBlock)e.getCloseFrame(channelId));
        if (closeProtocolSession) {
            this.closeProtocolSession();
        }
    }

    public void closeProtocolSession() {
        this.closeProtocolSession(true);
    }

    public void closeProtocolSession(boolean waitLast) {
        if (waitLast && this._lastWriteFuture != null) {
            _logger.debug((Object)"Waiting for last write to join.");
            this._lastWriteFuture.join(60000L);
        }
        _logger.debug((Object)("REALLY Closing protocol session:" + this._minaProtocolSession));
        CloseFuture future = this._minaProtocolSession.close();
        future.join(60000L);
        try {
            this._stateManager.changeState(AMQState.CONNECTION_CLOSED);
        }
        catch (AMQException e) {
            _logger.info((Object)e.getMessage());
        }
    }

    public String toString() {
        return this._minaProtocolSession.getRemoteAddress() + "(" + (this.getAuthorizedID() == null ? "?" : this.getAuthorizedID().getName() + ")");
    }

    public String dump() {
        return this + " last_sent=" + this._lastSent + " last_received=" + this._lastReceived;
    }

    @Override
    public Object getKey() {
        return this._minaProtocolSession.getRemoteAddress();
    }

    @Override
    public String getLocalFQDN() {
        SocketAddress address = this._minaProtocolSession.getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getHostName();
        }
        if (address instanceof VmPipeAddress) {
            return "vmpipe:" + ((VmPipeAddress)address).getPort();
        }
        throw new IllegalArgumentException("Unsupported socket address class: " + address);
    }

    @Override
    public SaslServer getSaslServer() {
        return this._saslServer;
    }

    @Override
    public void setSaslServer(SaslServer saslServer) {
        this._saslServer = saslServer;
    }

    @Override
    public FieldTable getClientProperties() {
        return this._clientProperties;
    }

    @Override
    public void setClientProperties(FieldTable clientProperties) {
        this._clientProperties = clientProperties;
        if (this._clientProperties != null) {
            if (this._clientProperties.getString(CLIENT_PROPERTIES_INSTANCE) != null) {
                this.setContextKey(new AMQShortString(this._clientProperties.getString(CLIENT_PROPERTIES_INSTANCE)));
            }
            if (this._clientProperties.getString(ClientProperties.version.toString()) != null) {
                this._clientVersion = new AMQShortString(this._clientProperties.getString(ClientProperties.version.toString()));
            }
        }
        this._sessionIdentifier = new AMQProtocolSession.ProtocolSessionIdentifier(this);
    }

    private void setProtocolVersion(ProtocolVersion pv) {
        this._protocolVersion = pv;
        this._protocolOutputConverter = ProtocolOutputConverterRegistry.getConverter(this);
        this._dispatcher = ServerMethodDispatcherImpl.createMethodDispatcher(this._stateManager, this._protocolVersion);
    }

    public byte getProtocolMajorVersion() {
        return this._protocolVersion.getMajorVersion();
    }

    public ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }

    public byte getProtocolMinorVersion() {
        return this._protocolVersion.getMinorVersion();
    }

    public boolean isProtocolVersion(byte major, byte minor) {
        return this.getProtocolMajorVersion() == major && this.getProtocolMinorVersion() == minor;
    }

    public MethodRegistry getRegistry() {
        return this.getMethodRegistry();
    }

    @Override
    public Object getClientIdentifier() {
        return this._minaProtocolSession != null ? this._minaProtocolSession.getRemoteAddress() : null;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public void setVirtualHost(VirtualHost virtualHost) throws AMQException {
        this._virtualHost = virtualHost;
        this._virtualHost.getConnectionRegistry().registerConnection(this);
        this._managedObject = this.createMBean();
        this._managedObject.register();
    }

    @Override
    public void addSessionCloseTask(AMQProtocolSession.Task task) {
        this._taskList.add(task);
    }

    @Override
    public void removeSessionCloseTask(AMQProtocolSession.Task task) {
        this._taskList.remove(task);
    }

    @Override
    public ProtocolOutputConverter getProtocolOutputConverter() {
        return this._protocolOutputConverter;
    }

    @Override
    public void setAuthorizedID(Principal authorizedID) {
        this._authorizedID = authorizedID;
    }

    @Override
    public Principal getAuthorizedID() {
        return this._authorizedID;
    }

    @Override
    public MethodRegistry getMethodRegistry() {
        return MethodRegistry.getMethodRegistry((ProtocolVersion)this.getProtocolVersion());
    }

    @Override
    public MethodDispatcher getMethodDispatcher() {
        return this._dispatcher;
    }

    @Override
    public AMQProtocolSession.ProtocolSessionIdentifier getSessionIdentifier() {
        return this._sessionIdentifier;
    }

    public String getClientVersion() {
        return this._clientVersion == null ? null : this._clientVersion.toString();
    }

    public void setSender(Sender<ByteBuffer> sender) {
    }

    public void init() {
    }
}

