/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.ReadThrottleFilterBuilder;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.WriteBufferLimitFilterBuilder;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.QpidProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.util.SessionUtil;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.AMQCodecFactory;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQProtocolHeaderException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.HeartbeatBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.protocol.AMQMinaProtocolSession;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.ssl.SSLContextFactory;

public class AMQPFastProtocolHandler
extends IoHandlerAdapter {
    private static final Logger _logger = Logger.getLogger(AMQPFastProtocolHandler.class);
    private final IApplicationRegistry _applicationRegistry;
    private final int BUFFER_READ_LIMIT_SIZE;
    private final int BUFFER_WRITE_LIMIT_SIZE;

    public AMQPFastProtocolHandler(Integer applicationRegistryInstance) {
        this(ApplicationRegistry.getInstance(applicationRegistryInstance));
    }

    public AMQPFastProtocolHandler(IApplicationRegistry applicationRegistry) {
        this._applicationRegistry = applicationRegistry;
        this.BUFFER_READ_LIMIT_SIZE = this._applicationRegistry.getConfiguration().getBufferReadLimit();
        this.BUFFER_WRITE_LIMIT_SIZE = this._applicationRegistry.getConfiguration().getBufferWriteLimit();
        _logger.debug((Object)"AMQPFastProtocolHandler created");
    }

    protected AMQPFastProtocolHandler(AMQPFastProtocolHandler handler) {
        this(handler._applicationRegistry);
    }

    public void sessionCreated(IoSession protocolSession) throws Exception {
        SessionUtil.initialize((IoSession)protocolSession);
        AMQCodecFactory codecFactory = new AMQCodecFactory(true);
        this.createSession(protocolSession, this._applicationRegistry, codecFactory);
        _logger.info((Object)("Protocol session created for:" + protocolSession.getRemoteAddress()));
        QpidProtocolCodecFilter pcf = new QpidProtocolCodecFilter((ProtocolCodecFactory)codecFactory);
        ServerConfiguration config = this._applicationRegistry.getConfiguration();
        String keystorePath = config.getKeystorePath();
        String keystorePassword = config.getKeystorePassword();
        String certType = config.getCertType();
        SSLContextFactory sslContextFactory = null;
        boolean isSsl = false;
        if (config.getEnableSSL() && this.isSSLClient(config, protocolSession)) {
            sslContextFactory = new SSLContextFactory(keystorePath, keystorePassword, certType);
            isSsl = true;
        }
        if (config.getEnableExecutorPool()) {
            if (isSsl) {
                protocolSession.getFilterChain().addAfter("AsynchronousReadFilter", "sslFilter", (IoFilter)new SSLFilter(sslContextFactory.buildServerContext()));
            }
            protocolSession.getFilterChain().addBefore("AsynchronousWriteFilter", "protocolFilter", (IoFilter)pcf);
        } else {
            protocolSession.getFilterChain().addLast("protocolFilter", (IoFilter)pcf);
            if (isSsl) {
                protocolSession.getFilterChain().addBefore("protocolFilter", "sslFilter", (IoFilter)new SSLFilter(sslContextFactory.buildServerContext()));
            }
        }
        if (ApplicationRegistry.getInstance().getConfiguration().getProtectIOEnabled()) {
            try {
                IoFilterChain chain = protocolSession.getFilterChain();
                protocolSession.getFilterChain().addLast("tempExecutorFilterForFilterBuilder", (IoFilter)new ExecutorFilter());
                ReadThrottleFilterBuilder readfilter = new ReadThrottleFilterBuilder();
                readfilter.setMaximumConnectionBufferSize(this.BUFFER_READ_LIMIT_SIZE);
                readfilter.attach(chain);
                WriteBufferLimitFilterBuilder writefilter = new WriteBufferLimitFilterBuilder();
                writefilter.setMaximumConnectionBufferSize((long)this.BUFFER_WRITE_LIMIT_SIZE);
                writefilter.attach(chain);
                protocolSession.getFilterChain().remove("tempExecutorFilterForFilterBuilder");
                _logger.info((Object)"Using IO Read/Write Filter Protection");
            }
            catch (Exception e) {
                _logger.error((Object)("Unable to attach IO Read/Write Filter Protection :" + e.getMessage()));
            }
        }
    }

    protected void createSession(IoSession session, IApplicationRegistry applicationRegistry, AMQCodecFactory codec) throws AMQException {
        new AMQMinaProtocolSession(session, applicationRegistry.getVirtualHostRegistry(), codec);
    }

    public void sessionOpened(IoSession protocolSession) throws Exception {
        _logger.info((Object)("Session opened for:" + protocolSession.getRemoteAddress()));
    }

    public void sessionClosed(IoSession protocolSession) throws Exception {
        _logger.info((Object)("Protocol Session closed for:" + protocolSession.getRemoteAddress()));
        AMQProtocolSession amqProtocolSession = AMQMinaProtocolSession.getAMQProtocolSession(protocolSession);
        if (amqProtocolSession != null) {
            try {
                amqProtocolSession.closeSession();
            }
            catch (AMQException e) {
                _logger.error((Object)("Caught AMQException whilst closingSession:" + (Object)((Object)e)));
            }
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        _logger.debug((Object)("Protocol Session [" + (Object)((Object)this) + "] idle: " + status + " :for:" + session.getRemoteAddress()));
        if (IdleStatus.WRITER_IDLE.equals(status)) {
            session.write((Object)HeartbeatBody.FRAME);
        } else if (IdleStatus.READER_IDLE.equals(status)) {
            throw new IOException("Timed out while waiting for heartbeat from peer.");
        }
    }

    public void exceptionCaught(IoSession protocolSession, Throwable throwable) throws Exception {
        AMQProtocolSession session = AMQMinaProtocolSession.getAMQProtocolSession(protocolSession);
        if (throwable instanceof AMQProtocolHeaderException) {
            protocolSession.write((Object)new ProtocolInitiation(ProtocolVersion.getLatestSupportedVersion()));
            protocolSession.close();
            _logger.error((Object)("Error in protocol initiation " + session + ":" + protocolSession.getRemoteAddress() + " :" + throwable.getMessage()), throwable);
        } else if (throwable instanceof IOException) {
            _logger.error((Object)("IOException caught in" + session + ", session closed implictly: " + throwable));
        } else {
            _logger.error((Object)("Exception caught in" + session + ", closing session explictly: " + throwable), throwable);
            MethodRegistry methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)session.getProtocolVersion());
            ConnectionCloseBody closeBody = methodRegistry.createConnectionCloseBody(200, new AMQShortString(throwable.getMessage()), 0, 0);
            protocolSession.write((Object)closeBody.generateFrame(0));
            protocolSession.close();
        }
    }

    public void messageReceived(IoSession protocolSession, Object message) throws Exception {
        AMQProtocolSession amqProtocolSession = AMQMinaProtocolSession.getAMQProtocolSession(protocolSession);
        if (!(message instanceof AMQDataBlock)) {
            if (message instanceof ByteBuffer) {
                throw new IllegalStateException("Handed undecoded ByteBuffer buf = " + message);
            }
            throw new IllegalStateException("Handed unhandled message. message.class = " + message.getClass() + " message = " + message);
        }
        amqProtocolSession.dataBlockReceived((AMQDataBlock)message);
    }

    public void messageSent(IoSession protocolSession, Object object) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Message sent: " + object));
        }
    }

    protected boolean isSSLClient(ServerConfiguration connectionConfig, IoSession protocolSession) {
        InetSocketAddress addr = (InetSocketAddress)protocolSession.getLocalAddress();
        return addr.getPort() == connectionConfig.getSSLPort();
    }
}

