/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.security.Principal;
import javax.security.sasl.SaslServer;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.AMQException;
import org.apache.qpid.common.ClientProperties;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.output.ProtocolOutputConverter;
import org.apache.qpid.server.virtualhost.VirtualHost;

public interface AMQProtocolSession
extends AMQVersionAwareProtocolSession {
    public void dataBlockReceived(AMQDataBlock var1) throws Exception;

    public AMQShortString getContextKey();

    public void setContextKey(AMQShortString var1);

    public AMQChannel getChannel(int var1) throws AMQException;

    public void addChannel(AMQChannel var1) throws AMQException;

    public void closeChannel(int var1) throws AMQException;

    public void closeChannelOk(int var1);

    public boolean channelAwaitingClosure(int var1);

    public void removeChannel(int var1);

    public void initHeartbeats(int var1);

    public void closeSession() throws AMQException;

    public void closeConnection(int var1, AMQConnectionException var2, boolean var3) throws AMQException;

    public Object getKey();

    public String getLocalFQDN();

    public SaslServer getSaslServer();

    public void setSaslServer(SaslServer var1);

    public FieldTable getClientProperties();

    public void setClientProperties(FieldTable var1);

    public Object getClientIdentifier();

    public VirtualHost getVirtualHost();

    public void setVirtualHost(VirtualHost var1) throws AMQException;

    public void addSessionCloseTask(Task var1);

    public void removeSessionCloseTask(Task var1);

    public ProtocolOutputConverter getProtocolOutputConverter();

    public void setAuthorizedID(Principal var1);

    public Principal getAuthorizedID();

    public MethodRegistry getMethodRegistry();

    public MethodDispatcher getMethodDispatcher();

    public ProtocolSessionIdentifier getSessionIdentifier();

    public static interface Task {
        public void doTask(AMQProtocolSession var1) throws AMQException;
    }

    public static final class ProtocolSessionIdentifier {
        private final Object _sessionIdentifier;
        private final Object _sessionInstance;

        ProtocolSessionIdentifier(AMQProtocolSession session) {
            this._sessionIdentifier = session.getClientIdentifier();
            this._sessionInstance = session.getClientProperties() == null ? null : session.getClientProperties().getObject(ClientProperties.instance.toAMQShortString());
        }

        public Object getSessionIdentifier() {
            return this._sessionIdentifier;
        }

        public Object getSessionInstance() {
            return this._sessionInstance;
        }
    }
}

