/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.util.Date;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.monitor.MonitorNotification;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.management.MBeanConstructor;
import org.apache.qpid.server.management.MBeanDescription;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.protocol.AMQMinaProtocolSession;
import org.apache.qpid.server.protocol.ManagedConnection;

@MBeanDescription(value="Management Bean for an AMQ Broker Connection")
public class AMQProtocolSessionMBean
extends AMQManagedObject
implements ManagedConnection {
    private AMQMinaProtocolSession _session = null;
    private String _name = null;
    private static final String[] _channelAtttibuteNames = new String[]{"Channel Id", "Transactional", "Default Queue", "Unacknowledged Message Count"};
    private static final String[] _indexNames = new String[]{_channelAtttibuteNames[0]};
    private static final OpenType[] _channelAttributeTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.INTEGER};
    private static CompositeType _channelType = null;
    private static TabularType _channelsType = null;
    private static final AMQShortString BROKER_MANAGEMENT_CONSOLE_HAS_CLOSED_THE_CONNECTION = new AMQShortString("Broker Management Console has closed the connection.");

    @MBeanConstructor(value="Creates an MBean exposing an AMQ Broker Connection")
    public AMQProtocolSessionMBean(AMQMinaProtocolSession session) throws NotCompliantMBeanException, OpenDataException {
        super(ManagedConnection.class, "Connection", 1);
        this._session = session;
        String remote = this.getRemoteAddress();
        remote = "anonymous".equals(remote) ? remote + this.hashCode() : remote;
        this._name = AMQProtocolSessionMBean.jmxEncode(new StringBuffer(remote), 0).toString();
        AMQProtocolSessionMBean.init();
    }

    private static void init() throws OpenDataException {
        _channelType = new CompositeType("Channel", "Channel Details", _channelAtttibuteNames, _channelAtttibuteNames, _channelAttributeTypes);
        _channelsType = new TabularType("Channels", "Channels", _channelType, _indexNames);
    }

    public String getClientId() {
        return this._session.getContextKey() == null ? null : this._session.getContextKey().toString();
    }

    public String getAuthorizedId() {
        return this._session.getAuthorizedID() != null ? this._session.getAuthorizedID().getName() : null;
    }

    public String getVersion() {
        return this._session.getClientVersion() == null ? null : this._session.getClientVersion().toString();
    }

    public Date getLastIoTime() {
        return new Date(this._session.getIOSession().getLastIoTime());
    }

    public String getRemoteAddress() {
        return this._session.getIOSession().getRemoteAddress().toString();
    }

    public ManagedObject getParentObject() {
        return this._session.getVirtualHost().getManagedObject();
    }

    public Long getWrittenBytes() {
        return this._session.getIOSession().getWrittenBytes();
    }

    public Long getReadBytes() {
        return this._session.getIOSession().getReadBytes();
    }

    public Long getMaximumNumberOfChannels() {
        return this._session.getMaximumNumberOfChannels();
    }

    public void setMaximumNumberOfChannels(Long value) {
        this._session.setMaximumNumberOfChannels(value);
    }

    public String getObjectInstanceName() {
        return this._name;
    }

    public void commitTransactions(int channelId) throws JMException {
        try {
            AMQChannel channel = this._session.getChannel(channelId);
            if (channel == null) {
                throw new JMException("The channel (channel Id = " + channelId + ") does not exist");
            }
            this._session.commitTransactions(channel);
        }
        catch (AMQException ex) {
            throw new MBeanException((Exception)((Object)ex), ex.toString());
        }
    }

    public void rollbackTransactions(int channelId) throws JMException {
        try {
            AMQChannel channel = this._session.getChannel(channelId);
            if (channel == null) {
                throw new JMException("The channel (channel Id = " + channelId + ") does not exist");
            }
            this._session.rollbackTransactions(channel);
        }
        catch (AMQException ex) {
            throw new MBeanException((Exception)((Object)ex), ex.toString());
        }
    }

    public TabularData channels() throws OpenDataException {
        TabularDataSupport channelsList = new TabularDataSupport(_channelsType);
        List<AMQChannel> list = this._session.getChannels();
        for (AMQChannel channel : list) {
            Object[] itemValues = new Object[]{channel.getChannelId(), channel.isTransactional(), channel.getDefaultQueue() != null ? channel.getDefaultQueue().getName().asString() : null, channel.getUnacknowledgedMessageMap().size()};
            CompositeDataSupport channelData = new CompositeDataSupport(_channelType, _channelAtttibuteNames, itemValues);
            channelsList.put(channelData);
        }
        return channelsList;
    }

    public void closeConnection() throws JMException {
        MethodRegistry methodRegistry = this._session.getMethodRegistry();
        ConnectionCloseBody responseBody = methodRegistry.createConnectionCloseBody(AMQConstant.REPLY_SUCCESS.getCode(), BROKER_MANAGEMENT_CONSOLE_HAS_CLOSED_THE_CONNECTION, 0, 0);
        this._session.writeFrame((AMQDataBlock)responseBody.generateFrame(0));
        try {
            this._session.closeSession();
        }
        catch (AMQException ex) {
            throw new MBeanException((Exception)((Object)ex), ex.toString());
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] notificationTypes = new String[]{"jmx.monitor.counter.threshold"};
        String name = MonitorNotification.class.getName();
        String description = "Channel count has reached threshold value";
        MBeanNotificationInfo info1 = new MBeanNotificationInfo(notificationTypes, name, description);
        return new MBeanNotificationInfo[]{info1};
    }

    public void notifyClients(String notificationMsg) {
        Notification n = new Notification("jmx.monitor.counter.threshold", this, ++this._notificationSequenceNumber, System.currentTimeMillis(), notificationMsg);
        this._broadcaster.sendNotification(n);
    }

    static {
        try {
            AMQProtocolSessionMBean.init();
        }
        catch (JMException ex) {
            throw new RuntimeException("Got JMException in static initializer.", ex);
        }
    }
}

