/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import org.apache.qpid.AMQException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.exchange.ExchangeType;

public class ExchangeInitialiser {
    public void initialise(ExchangeFactory factory, ExchangeRegistry registry) throws AMQException {
        for (ExchangeType<? extends Exchange> type : factory.getRegisteredTypes()) {
            this.define(registry, factory, type.getDefaultExchangeName(), type.getName());
        }
        this.define(registry, factory, ExchangeDefaults.DEFAULT_EXCHANGE_NAME, ExchangeDefaults.DIRECT_EXCHANGE_CLASS);
        registry.setDefaultExchange(registry.getExchange(ExchangeDefaults.DEFAULT_EXCHANGE_NAME));
    }

    private void define(ExchangeRegistry r, ExchangeFactory f, AMQShortString name, AMQShortString type) throws AMQException {
        if (r.getExchange(name) == null) {
            r.registerExchange(f.createExchange(name, type, true, false, 0));
        }
    }
}

