/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.io.IOException;
import java.util.Date;
import javax.management.JMException;
import javax.management.openmbean.TabularData;
import org.apache.qpid.server.management.MBeanAttribute;
import org.apache.qpid.server.management.MBeanOperation;
import org.apache.qpid.server.management.MBeanOperationParameter;

public interface ManagedConnection {
    public static final String TYPE = "Connection";
    public static final int VERSION = 1;

    @MBeanAttribute(name="ClientId", description="Client Id")
    public String getClientId();

    @MBeanAttribute(name="AuthorizedId", description="User Name")
    public String getAuthorizedId();

    @MBeanAttribute(name="Version", description="Client Version")
    public String getVersion();

    @MBeanAttribute(name="RemoteAddress", description="Connection Address")
    public String getRemoteAddress();

    @MBeanAttribute(name="LastIOTime", description="The last time, the IO operation was done")
    public Date getLastIoTime();

    public Long getMaximumNumberOfChannels();

    @MBeanAttribute(name="MaximumNumberOfChannels", description="The threshold high value for number of channels for this connection")
    public void setMaximumNumberOfChannels(Long var1);

    @MBeanOperation(name="channels", description="Channel details for this connection")
    public TabularData channels() throws IOException, JMException;

    @MBeanOperation(name="commitTransaction", description="Commits the transactions for given channel Id, if the channel is transactional", impact=1)
    public void commitTransactions(@MBeanOperationParameter(name="channel Id", description="channel Id") int var1) throws JMException;

    @MBeanOperation(name="rollbackTransactions", description="Rollsback the transactions for given channel Id, if the channel is transactional", impact=1)
    public void rollbackTransactions(@MBeanOperationParameter(name="channel Id", description="channel Id") int var1) throws JMException;

    @MBeanOperation(name="closeConnection", description="Closes this connection and all related channels", impact=1)
    public void closeConnection() throws Exception;
}

