/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.framing.abstraction.ProtocolVersionMethodConverter;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQMessageHandle;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.Filterable;
import org.apache.qpid.server.queue.MessageCleanupException;
import org.apache.qpid.server.queue.MessageHandleFactory;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.txn.TransactionalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQMessage
implements Filterable<AMQException> {
    private static final Logger _log = Logger.getLogger(AMQMessage.class);
    private final AtomicInteger _referenceCount = new AtomicInteger(1);
    private final AMQMessageHandle _messageHandle;
    private StoreContext _storeContext;
    private static final byte IMMEDIATE = 1;
    private static final byte DELIVERED_TO_CONSUMER = 2;
    private byte _flags = 0;
    private long _expiration;
    private final long _size;
    private AMQProtocolSession.ProtocolSessionIdentifier _sessionIdentifier;
    private static final byte IMMEDIATE_AND_DELIVERED = 3;

    public void clearStoreContext() {
        this._storeContext = new StoreContext();
    }

    public StoreContext getStoreContext() {
        return this._storeContext;
    }

    public AMQMessage(Long messageId, MessageStore store, MessageHandleFactory factory, TransactionalContext txnConext) throws AMQException {
        this._messageHandle = factory.createMessageHandle(messageId, store, true);
        this._storeContext = txnConext.getStoreContext();
        this._size = this._messageHandle.getBodySize(txnConext.getStoreContext());
    }

    public AMQMessage(AMQMessageHandle messageHandle, StoreContext storeConext, MessagePublishInfo info) throws AMQException {
        this._messageHandle = messageHandle;
        this._storeContext = storeConext;
        if (info.isImmediate()) {
            this._flags = (byte)(this._flags | 1);
        }
        this._size = messageHandle.getBodySize(storeConext);
    }

    protected AMQMessage(AMQMessage msg) throws AMQException {
        this._messageHandle = msg._messageHandle;
        this._storeContext = msg._storeContext;
        this._flags = msg._flags;
        this._size = msg._size;
    }

    public String debugIdentity() {
        return "(HC:" + System.identityHashCode(this) + " ID:" + this.getMessageId() + " Ref:" + this._referenceCount.get() + ")";
    }

    public void setExpiration(long expiration) {
        this._expiration = expiration;
    }

    public boolean isReferenced() {
        return this._referenceCount.get() > 0;
    }

    public Iterator<AMQDataBlock> getBodyFrameIterator(AMQProtocolSession protocolSession, int channel) {
        return new BodyFrameIterator(protocolSession, channel);
    }

    public Iterator<ContentChunk> getContentBodyIterator() {
        return new BodyContentIterator();
    }

    @Override
    public ContentHeaderBody getContentHeaderBody() throws AMQException {
        return this._messageHandle.getContentHeaderBody(this.getStoreContext());
    }

    public Long getMessageId() {
        return this._messageHandle.getMessageId();
    }

    public AMQMessage takeReference() {
        this.incrementReference();
        return this;
    }

    public boolean incrementReference() {
        return this.incrementReference(1);
    }

    public boolean incrementReference(int count) {
        if (this._referenceCount.addAndGet(count) <= 1) {
            this._referenceCount.addAndGet(-count);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decrementReference(StoreContext storeContext) throws MessageCleanupException {
        int count = this._referenceCount.decrementAndGet();
        if (count == 0) {
            this._referenceCount.set(-1073741824);
            try {
                if (this._messageHandle == null) return;
                this._messageHandle.removeMessage(storeContext);
                return;
            }
            catch (AMQException e) {
                this.incrementReference();
                throw new MessageCleanupException(this.getMessageId(), e);
            }
        } else {
            if (count >= 0) return;
            throw new MessageCleanupException("Reference count for message id " + this.debugIdentity() + " has gone below 0.");
        }
    }

    public boolean getDeliveredToConsumer() {
        return (this._flags & 2) != 0;
    }

    @Override
    public boolean isPersistent() throws AMQException {
        return this._messageHandle.isPersistent();
    }

    public boolean immediateAndNotDelivered() {
        return (this._flags & 3) == 1;
    }

    public MessagePublishInfo getMessagePublishInfo() throws AMQException {
        return this._messageHandle.getMessagePublishInfo(this.getStoreContext());
    }

    @Override
    public boolean isRedelivered() {
        return this._messageHandle.isRedelivered();
    }

    public void setRedelivered(boolean redelivered) {
        this._messageHandle.setRedelivered(redelivered);
    }

    public long getArrivalTime() {
        return this._messageHandle.getArrivalTime();
    }

    public boolean expired(AMQQueue queue) throws AMQException {
        if (this._expiration != 0L) {
            long now = System.currentTimeMillis();
            return now > this._expiration;
        }
        return false;
    }

    public void setDeliveredToConsumer() {
        this._flags = (byte)(this._flags | 2);
    }

    public AMQMessageHandle getMessageHandle() {
        return this._messageHandle;
    }

    public long getSize() {
        return this._size;
    }

    public Object getPublisherClientInstance() {
        if (this._sessionIdentifier == null) {
            return null;
        }
        return this._sessionIdentifier.getSessionInstance();
    }

    public Object getPublisherIdentifier() {
        if (this._sessionIdentifier == null) {
            return null;
        }
        return this._sessionIdentifier.getSessionIdentifier();
    }

    public void setClientIdentifier(AMQProtocolSession.ProtocolSessionIdentifier sessionIdentifier) {
        this._sessionIdentifier = sessionIdentifier;
    }

    public String toString() {
        return "Message[" + this.debugIdentity() + "]: " + this.getMessageId() + "; ref count: " + this._referenceCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BodyContentIterator
    implements Iterator<ContentChunk> {
        private int _index = -1;

        private BodyContentIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                return this._index < AMQMessage.this._messageHandle.getBodyCount(AMQMessage.this.getStoreContext()) - 1;
            }
            catch (AMQException e) {
                _log.error((Object)("Error getting body count: " + (Object)((Object)e)), (Throwable)e);
                return false;
            }
        }

        @Override
        public ContentChunk next() {
            try {
                return AMQMessage.this._messageHandle.getContentChunk(AMQMessage.this.getStoreContext(), ++this._index);
            }
            catch (AMQException e) {
                throw new RuntimeException("Error getting content body: " + (Object)((Object)e), e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BodyFrameIterator
    implements Iterator<AMQDataBlock> {
        private int _channel;
        private int _index = -1;
        private AMQProtocolSession _protocolSession;

        private BodyFrameIterator(AMQProtocolSession protocolSession, int channel) {
            this._channel = channel;
            this._protocolSession = protocolSession;
        }

        @Override
        public boolean hasNext() {
            try {
                return this._index < AMQMessage.this._messageHandle.getBodyCount(AMQMessage.this.getStoreContext()) - 1;
            }
            catch (AMQException e) {
                _log.error((Object)("Unable to get body count: " + (Object)((Object)e)), (Throwable)e);
                return false;
            }
        }

        @Override
        public AMQDataBlock next() {
            try {
                AMQBody cb = this.getProtocolVersionMethodConverter().convertToBody(AMQMessage.this._messageHandle.getContentChunk(AMQMessage.this.getStoreContext(), ++this._index));
                return new AMQFrame(this._channel, cb);
            }
            catch (AMQException e) {
                throw new RuntimeException("Error getting content body: " + (Object)((Object)e), e);
            }
        }

        private ProtocolVersionMethodConverter getProtocolVersionMethodConverter() {
            return this._protocolSession.getMethodRegistry().getProtocolVersionMethodConverter();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

