/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.queue.PriorityQueueList;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.SimpleAMQQueue;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.subscription.SubscriptionList;
import org.apache.qpid.server.virtualhost.VirtualHost;

public class AMQPriorityQueue
extends SimpleAMQQueue {
    protected AMQPriorityQueue(AMQShortString name, boolean durable, AMQShortString owner, boolean autoDelete, VirtualHost virtualHost, int priorities) throws AMQException {
        super(name, durable, owner, autoDelete, virtualHost, new PriorityQueueList.Factory(priorities));
    }

    public int getPriorities() {
        return ((PriorityQueueList)this._entries).getPriorities();
    }

    protected void checkSubscriptionsNotAheadOfDelivery(QueueEntry entry) {
        SubscriptionList.SubscriptionNodeIterator subIter = this._subscriptionList.iterator();
        while (subIter.advance() && !entry.isAcquired()) {
            Subscription subscription = subIter.getNode().getSubscription();
            QueueEntry subnode = subscription.getLastSeenEntry();
            while (subnode != null && entry.compareTo(subnode) < 0 && !entry.isAcquired() && !subscription.setLastSeenEntry(subnode, entry)) {
                subnode = subscription.getLastSeenEntry();
            }
        }
    }
}

