/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.List;
import java.util.Set;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.management.Managable;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.ExchangeBinding;
import org.apache.qpid.server.queue.FailedDequeueException;
import org.apache.qpid.server.queue.NotificationCheck;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AMQQueue
extends Managable,
Comparable<AMQQueue> {
    public AMQShortString getName();

    public boolean isDurable();

    public boolean isAutoDelete();

    public AMQShortString getOwner();

    public VirtualHost getVirtualHost();

    public void bind(Exchange var1, AMQShortString var2, FieldTable var3) throws AMQException;

    public void unBind(Exchange var1, AMQShortString var2, FieldTable var3) throws AMQException;

    public List<ExchangeBinding> getExchangeBindings();

    public void registerSubscription(Subscription var1, boolean var2) throws AMQException;

    public void unregisterSubscription(Subscription var1) throws AMQException;

    public int getConsumerCount();

    public int getActiveConsumerCount();

    public boolean isUnused();

    public boolean isEmpty();

    public int getMessageCount();

    public int getUndeliveredMessageCount();

    public long getQueueDepth();

    public long getReceivedMessageCount();

    public long getOldestMessageArrivalTime();

    public boolean isDeleted();

    public int delete() throws AMQException;

    public QueueEntry enqueue(StoreContext var1, AMQMessage var2) throws AMQException;

    public void requeue(StoreContext var1, QueueEntry var2) throws AMQException;

    public void dequeue(StoreContext var1, QueueEntry var2) throws FailedDequeueException;

    public boolean resend(QueueEntry var1, Subscription var2) throws AMQException;

    public void addQueueDeleteTask(Task var1);

    public List<QueueEntry> getMessagesOnTheQueue();

    public List<QueueEntry> getMessagesOnTheQueue(long var1, long var3);

    public List<Long> getMessagesOnTheQueue(int var1);

    public List<Long> getMessagesOnTheQueue(int var1, int var2);

    public QueueEntry getMessageOnTheQueue(long var1);

    public void moveMessagesToAnotherQueue(long var1, long var3, String var5, StoreContext var6);

    public void copyMessagesToAnotherQueue(long var1, long var3, String var5, StoreContext var6);

    public void removeMessagesFromQueue(long var1, long var3, StoreContext var5);

    public long getMaximumMessageSize();

    public void setMaximumMessageSize(long var1);

    public long getMaximumMessageCount();

    public void setMaximumMessageCount(long var1);

    public long getMaximumQueueDepth();

    public void setMaximumQueueDepth(long var1);

    public long getMaximumMessageAge();

    public void setMaximumMessageAge(long var1);

    public long getMinimumAlertRepeatGap();

    public void setMinimumAlertRepeatGap(long var1);

    public void deleteMessageFromTop(StoreContext var1) throws AMQException;

    public long clearQueue(StoreContext var1) throws AMQException;

    public void checkMessageStatus() throws AMQException;

    public Set<NotificationCheck> getNotificationChecks();

    public void flushSubscription(Subscription var1) throws AMQException;

    public void deliverAsync(Subscription var1);

    public void deliverAsync();

    public void stop();

    public void configure(QueueConfiguration var1);

    public static interface Task {
        public void doTask(AMQQueue var1) throws AMQException;
    }

    public static final class ExistingSubscriptionPreventsExclusive
    extends AMQException {
        public ExistingSubscriptionPreventsExclusive() {
            super("");
        }
    }

    public static final class ExistingExclusiveSubscription
    extends AMQException {
        public ExistingExclusiveSubscription() {
            super("");
        }
    }
}

