/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.queue.AMQPriorityQueue;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.SimpleAMQQueue;
import org.apache.qpid.server.virtualhost.VirtualHost;

public class AMQQueueFactory {
    public static final AMQShortString X_QPID_PRIORITIES = new AMQShortString("x-qpid-priorities");

    public static AMQQueue createAMQQueueImpl(AMQShortString name, boolean durable, AMQShortString owner, boolean autoDelete, VirtualHost virtualHost, FieldTable arguments) throws AMQException {
        int priorities = arguments == null ? 1 : (arguments.containsKey(X_QPID_PRIORITIES) ? arguments.getInteger(X_QPID_PRIORITIES) : 1);
        SimpleAMQQueue q = null;
        q = priorities > 1 ? new AMQPriorityQueue(name, durable, owner, autoDelete, virtualHost, priorities) : new SimpleAMQQueue(name, durable, owner, autoDelete, virtualHost);
        virtualHost.getQueueRegistry().registerQueue(q);
        q.configure(virtualHost.getConfiguration().getQueueConfiguration(name.asString()));
        return q;
    }

    public static AMQQueue createAMQQueueImpl(QueueConfiguration config, VirtualHost host) throws AMQException {
        AMQShortString queueName = new AMQShortString(config.getName());
        boolean durable = config.getDurable();
        boolean autodelete = config.getAutoDelete();
        AMQShortString owner = config.getOwner() != null ? new AMQShortString(config.getOwner()) : null;
        FieldTable arguments = null;
        boolean priority = config.getPriority();
        int priorities = config.getPriorities();
        if (priority || priorities > 0) {
            if (arguments == null) {
                arguments = new FieldTable();
            }
            if (priorities < 0) {
                priorities = 10;
            }
            arguments.put(new AMQShortString("x-qpid-priorities"), (Object)priorities);
        }
        AMQQueue q = AMQQueueFactory.createAMQQueueImpl(queueName, durable, owner, autodelete, host, arguments);
        q.configure(config);
        return q;
    }
}

