/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.OperationsException;
import javax.management.monitor.MonitorNotification;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.log4j.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.CommonContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.management.MBeanConstructor;
import org.apache.qpid.server.management.MBeanDescription;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.ManagedQueue;
import org.apache.qpid.server.queue.NotificationCheck;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueNotificationListener;
import org.apache.qpid.server.store.StoreContext;

@MBeanDescription(value="Management Interface for AMQQueue")
public class AMQQueueMBean
extends AMQManagedObject
implements ManagedQueue,
QueueNotificationListener {
    private static final Logger _logger = Logger.getLogger(AMQQueueMBean.class);
    private static final SimpleDateFormat _dateFormat = new SimpleDateFormat("MM-dd-yy HH:mm:ss.SSS z");
    private StoreContext _storeContext = new StoreContext();
    private AMQQueue _queue = null;
    private String _queueName = null;
    private static final String[] _msgAttributeNames = new String[]{"AMQ MessageId", "Header", "Size(bytes)", "Redelivered"};
    private static String[] _msgAttributeIndex = new String[]{_msgAttributeNames[0]};
    private static OpenType[] _msgAttributeTypes = new OpenType[4];
    private static CompositeType _messageDataType = null;
    private static TabularType _messagelistDataType = null;
    private static CompositeType _msgContentType = null;
    private static final String[] _msgContentAttributes = new String[]{"AMQ MessageId", "MimeType", "Encoding", "Content"};
    private static OpenType[] _msgContentAttributeTypes = new OpenType[4];
    private final long[] _lastNotificationTimes = new long[NotificationCheck.values().length];
    private Notification _lastNotification = null;

    @MBeanConstructor(value="Creates an MBean exposing an AMQQueue")
    public AMQQueueMBean(AMQQueue queue) throws JMException {
        super(ManagedQueue.class, "Queue", 2);
        this._queue = queue;
        this._queueName = AMQQueueMBean.jmxEncode(new StringBuffer((CharSequence)queue.getName()), 0).toString();
    }

    public ManagedObject getParentObject() {
        return this._queue.getVirtualHost().getManagedObject();
    }

    private static void init() throws OpenDataException {
        AMQQueueMBean._msgContentAttributeTypes[0] = SimpleType.LONG;
        AMQQueueMBean._msgContentAttributeTypes[1] = SimpleType.STRING;
        AMQQueueMBean._msgContentAttributeTypes[2] = SimpleType.STRING;
        AMQQueueMBean._msgContentAttributeTypes[3] = new ArrayType(1, SimpleType.BYTE);
        _msgContentType = new CompositeType("Message Content", "AMQ Message Content", _msgContentAttributes, _msgContentAttributes, _msgContentAttributeTypes);
        AMQQueueMBean._msgAttributeTypes[0] = SimpleType.LONG;
        AMQQueueMBean._msgAttributeTypes[1] = new ArrayType(1, SimpleType.STRING);
        AMQQueueMBean._msgAttributeTypes[2] = SimpleType.LONG;
        AMQQueueMBean._msgAttributeTypes[3] = SimpleType.BOOLEAN;
        _messageDataType = new CompositeType("Message", "AMQ Message", _msgAttributeNames, _msgAttributeNames, _msgAttributeTypes);
        _messagelistDataType = new TabularType("Messages", "List of messages", _messageDataType, _msgAttributeIndex);
    }

    public String getObjectInstanceName() {
        return this._queueName;
    }

    public String getName() {
        return this._queueName;
    }

    public boolean isDurable() {
        return this._queue.isDurable();
    }

    public String getOwner() {
        return String.valueOf(this._queue.getOwner());
    }

    public boolean isAutoDelete() {
        return this._queue.isAutoDelete();
    }

    public Integer getMessageCount() {
        return this._queue.getMessageCount();
    }

    public Long getMaximumMessageSize() {
        return this._queue.getMaximumMessageSize();
    }

    public Long getMaximumMessageAge() {
        return this._queue.getMaximumMessageAge();
    }

    public void setMaximumMessageAge(Long maximumMessageAge) {
        this._queue.setMaximumMessageAge(maximumMessageAge);
    }

    public void setMaximumMessageSize(Long value) {
        this._queue.setMaximumMessageSize(value);
    }

    public Integer getConsumerCount() {
        return this._queue.getConsumerCount();
    }

    public Integer getActiveConsumerCount() {
        return this._queue.getActiveConsumerCount();
    }

    public Long getReceivedMessageCount() {
        return this._queue.getReceivedMessageCount();
    }

    public Long getMaximumMessageCount() {
        return this._queue.getMaximumMessageCount();
    }

    public void setMaximumMessageCount(Long value) {
        this._queue.setMaximumMessageCount(value);
    }

    public Long getMaximumQueueDepth() {
        return this._queue.getMaximumQueueDepth();
    }

    public void setMaximumQueueDepth(Long value) {
        this._queue.setMaximumQueueDepth(value);
    }

    public Long getQueueDepth() throws JMException {
        return this._queue.getQueueDepth();
    }

    public void checkForNotification(AMQMessage msg) throws AMQException {
        Set<NotificationCheck> notificationChecks = this._queue.getNotificationChecks();
        if (!notificationChecks.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            long thresholdTime = currentTime - this._queue.getMinimumAlertRepeatGap();
            for (NotificationCheck check : notificationChecks) {
                if (!check.isMessageSpecific() && this._lastNotificationTimes[check.ordinal()] >= thresholdTime || !check.notifyIfNecessary(msg, this._queue, this)) continue;
                this._lastNotificationTimes[check.ordinal()] = currentTime;
            }
        }
    }

    public void notifyClients(NotificationCheck notification, AMQQueue queue, String notificationMsg) {
        _logger.info((Object)(notification.name() + " On Queue " + queue.getName() + " - " + notificationMsg));
        notificationMsg = notification.name() + " " + notificationMsg;
        this._lastNotification = new Notification("jmx.monitor.counter.threshold", this, ++this._notificationSequenceNumber, System.currentTimeMillis(), notificationMsg);
        this._broadcaster.sendNotification(this._lastNotification);
    }

    public Notification getLastNotification() {
        return this._lastNotification;
    }

    public void deleteMessageFromTop() throws JMException {
        try {
            this._queue.deleteMessageFromTop(this._storeContext);
        }
        catch (AMQException ex) {
            throw new MBeanException((Exception)((Object)ex), ex.toString());
        }
    }

    public void clearQueue() throws JMException {
        try {
            this._queue.clearQueue(this._storeContext);
        }
        catch (AMQException ex) {
            throw new MBeanException((Exception)((Object)ex), ex.toString());
        }
    }

    public CompositeData viewMessageContent(long msgId) throws JMException {
        QueueEntry entry = this._queue.getMessageOnTheQueue(msgId);
        if (entry == null) {
            throw new OperationsException("AMQMessage with message id = " + msgId + " is not in the " + this._queueName);
        }
        AMQMessage msg = entry.getMessage();
        Iterator<ContentChunk> cBodies = msg.getContentBodyIterator();
        ArrayList<Byte> msgContent = new ArrayList<Byte>();
        while (cBodies.hasNext()) {
            ContentChunk body = cBodies.next();
            if (body.getSize() == 0 || body.getSize() == 0) continue;
            ByteBuffer slice = body.getData().slice();
            for (int j = 0; j < slice.limit(); ++j) {
                msgContent.add(slice.get());
            }
        }
        try {
            CommonContentHeaderProperties headerProperties = (CommonContentHeaderProperties)msg.getContentHeaderBody().properties;
            String mimeType = null;
            String encoding = null;
            if (headerProperties != null) {
                AMQShortString mimeTypeShortSting = headerProperties.getContentType();
                mimeType = mimeTypeShortSting == null ? null : mimeTypeShortSting.toString();
                encoding = headerProperties.getEncoding() == null ? "" : headerProperties.getEncoding().toString();
            }
            Object[] itemValues = new Object[]{msgId, mimeType, encoding, msgContent.toArray(new Byte[0])};
            return new CompositeDataSupport(_msgContentType, _msgContentAttributes, itemValues);
        }
        catch (AMQException e) {
            JMException jme = new JMException("Error creating header attributes list: " + (Object)((Object)e));
            jme.initCause(e);
            throw jme;
        }
    }

    public TabularData viewMessages(int beginIndex, int endIndex) throws JMException {
        if (beginIndex > endIndex || beginIndex < 1) {
            throw new OperationsException("From Index = " + beginIndex + ", To Index = " + endIndex + "\n\"From Index\" should be greater than 0 and less than \"To Index\"");
        }
        List<QueueEntry> list = this._queue.getMessagesOnTheQueue();
        TabularDataSupport _messageList = new TabularDataSupport(_messagelistDataType);
        try {
            for (int i = beginIndex; i <= endIndex && i <= list.size(); ++i) {
                AMQMessage msg = list.get(i - 1).getMessage();
                ContentHeaderBody headerBody = msg.getContentHeaderBody();
                String[] headerAttributes = this.getMessageHeaderProperties(headerBody);
                Object[] itemValues = new Object[]{msg.getMessageId(), headerAttributes, headerBody.bodySize, msg.isRedelivered()};
                CompositeDataSupport messageData = new CompositeDataSupport(_messageDataType, _msgAttributeNames, itemValues);
                _messageList.put(messageData);
            }
        }
        catch (AMQException e) {
            JMException jme = new JMException("Error creating message contents: " + (Object)((Object)e));
            jme.initCause(e);
            throw jme;
        }
        return _messageList;
    }

    private String[] getMessageHeaderProperties(ContentHeaderBody headerBody) {
        ArrayList<String> list = new ArrayList<String>();
        BasicContentHeaderProperties headerProperties = (BasicContentHeaderProperties)headerBody.properties;
        list.add("reply-to = " + headerProperties.getReplyToAsString());
        list.add("propertyFlags = " + headerProperties.getPropertyFlags());
        list.add("ApplicationID = " + headerProperties.getAppIdAsString());
        list.add("ClusterID = " + headerProperties.getClusterIdAsString());
        list.add("UserId = " + headerProperties.getUserIdAsString());
        list.add("JMSMessageID = " + headerProperties.getMessageIdAsString());
        list.add("JMSCorrelationID = " + headerProperties.getCorrelationIdAsString());
        byte delMode = headerProperties.getDeliveryMode();
        list.add("JMSDeliveryMode = " + (delMode == 1 ? "Persistent" : "Non_Persistent"));
        list.add("JMSPriority = " + headerProperties.getPriority());
        list.add("JMSType = " + headerProperties.getType());
        long longDate = headerProperties.getExpiration();
        String strDate = longDate != 0L ? _dateFormat.format(new Date(longDate)) : null;
        list.add("JMSExpiration = " + strDate);
        longDate = headerProperties.getTimestamp();
        strDate = longDate != 0L ? _dateFormat.format(new Date(longDate)) : null;
        list.add("JMSTimestamp = " + strDate);
        return list.toArray(new String[list.size()]);
    }

    public void moveMessages(long fromMessageId, long toMessageId, String toQueueName) throws JMException {
        if (fromMessageId > toMessageId || fromMessageId < 1L) {
            throw new OperationsException("\"From MessageId\" should be greater then 0 and less then \"To MessageId\"");
        }
        this._queue.moveMessagesToAnotherQueue(fromMessageId, toMessageId, toQueueName, this._storeContext);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] notificationTypes = new String[]{"jmx.monitor.counter.threshold"};
        String name = MonitorNotification.class.getName();
        String description = "Either Message count or Queue depth or Message size has reached threshold high value";
        MBeanNotificationInfo info1 = new MBeanNotificationInfo(notificationTypes, name, description);
        return new MBeanNotificationInfo[]{info1};
    }

    static {
        try {
            AMQQueueMBean.init();
        }
        catch (JMException ex) {
            throw new RuntimeException("Got JMException in static initializer.", ex);
        }
    }
}

