/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;

public class ExchangeBinding {
    private final Exchange _exchange;
    private final AMQShortString _routingKey;
    private final FieldTable _arguments;
    private static final FieldTable EMPTY_ARGUMENTS = new FieldTable();

    ExchangeBinding(AMQShortString routingKey, Exchange exchange) {
        this(routingKey, exchange, EMPTY_ARGUMENTS);
    }

    ExchangeBinding(AMQShortString routingKey, Exchange exchange, FieldTable arguments) {
        this._routingKey = routingKey == null ? AMQShortString.EMPTY_STRING : routingKey;
        this._exchange = exchange;
        this._arguments = arguments == null ? EMPTY_ARGUMENTS : arguments;
    }

    void unbind(AMQQueue queue) throws AMQException {
        this._exchange.deregisterQueue(this._routingKey, queue, this._arguments);
    }

    public Exchange getExchange() {
        return this._exchange;
    }

    public AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public FieldTable getArguments() {
        return this._arguments;
    }

    public int hashCode() {
        return (this._exchange == null ? 0 : this._exchange.hashCode()) + (this._routingKey == null ? 0 : this._routingKey.hashCode());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExchangeBinding)) {
            return false;
        }
        ExchangeBinding eb = (ExchangeBinding)o;
        return this._exchange.equals(eb._exchange) && this._routingKey.equals(eb._routingKey);
    }
}

