/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.ExchangeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExchangeBindings {
    private final List<ExchangeBinding> _bindings = new CopyOnWriteArrayList<ExchangeBinding>();
    private final AMQQueue _queue;

    ExchangeBindings(AMQQueue queue) {
        this._queue = queue;
    }

    void addBinding(AMQShortString routingKey, FieldTable arguments, Exchange exchange) {
        this._bindings.add(new ExchangeBinding(routingKey, exchange, arguments));
    }

    public boolean remove(AMQShortString routingKey, FieldTable arguments, Exchange exchange) {
        return this._bindings.remove(new ExchangeBinding(routingKey, exchange, arguments));
    }

    void deregister() throws AMQException {
        HashSet<ExchangeBinding> copy = new HashSet<ExchangeBinding>(this._bindings);
        for (ExchangeBinding b : copy) {
            b.unbind(this._queue);
        }
    }

    List<ExchangeBinding> getExchangeBindings() {
        return this._bindings;
    }
}

