/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.queue.AMQMessageHandle;
import org.apache.qpid.server.store.StoreContext;

public class InMemoryMessageHandle
implements AMQMessageHandle {
    private ContentHeaderBody _contentHeaderBody;
    private MessagePublishInfo _messagePublishInfo;
    private List<ContentChunk> _contentBodies;
    private boolean _redelivered;
    private long _arrivalTime;
    private final Long _messageId;

    public InMemoryMessageHandle(Long messageId) {
        this._messageId = messageId;
    }

    public ContentHeaderBody getContentHeaderBody(StoreContext context) throws AMQException {
        return this._contentHeaderBody;
    }

    public Long getMessageId() {
        return this._messageId;
    }

    public int getBodyCount(StoreContext context) {
        return this._contentBodies.size();
    }

    public long getBodySize(StoreContext context) throws AMQException {
        return this.getContentHeaderBody((StoreContext)context).bodySize;
    }

    public ContentChunk getContentChunk(StoreContext context, int index) throws AMQException, IllegalArgumentException {
        if (index > this._contentBodies.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of valid range 0 to " + (this._contentBodies.size() - 1));
        }
        return this._contentBodies.get(index);
    }

    public void addContentBodyFrame(StoreContext storeContext, ContentChunk contentBody, boolean isLastContentBody) throws AMQException {
        if (this._contentBodies == null) {
            if (isLastContentBody) {
                this._contentBodies = Collections.singletonList(contentBody);
            } else {
                this._contentBodies = new ArrayList<ContentChunk>();
                this._contentBodies.add(contentBody);
            }
        } else {
            this._contentBodies.add(contentBody);
        }
    }

    public MessagePublishInfo getMessagePublishInfo(StoreContext context) throws AMQException {
        return this._messagePublishInfo;
    }

    public boolean isRedelivered() {
        return this._redelivered;
    }

    public void setRedelivered(boolean redelivered) {
        this._redelivered = redelivered;
    }

    public boolean isPersistent() {
        return false;
    }

    public void setPublishAndContentHeaderBody(StoreContext storeContext, MessagePublishInfo messagePublishInfo, ContentHeaderBody contentHeaderBody) throws AMQException {
        this._messagePublishInfo = messagePublishInfo;
        this._contentHeaderBody = contentHeaderBody;
        if (contentHeaderBody.bodySize == 0L) {
            this._contentBodies = Collections.EMPTY_LIST;
        }
        this._arrivalTime = System.currentTimeMillis();
    }

    public void removeMessage(StoreContext storeContext) throws AMQException {
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }
}

