/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.NoRouteException;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.AMQMessageHandle;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.Filterable;
import org.apache.qpid.server.queue.MessageHandleFactory;
import org.apache.qpid.server.queue.UnauthorizedAccessException;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.txn.TransactionalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingMessage
implements Filterable<RuntimeException> {
    private static final Logger _logger = Logger.getLogger(IncomingMessage.class);
    private static final boolean SYNCHED_CLOCKS = ApplicationRegistry.getInstance().getConfiguration().getSynchedClocks();
    private final MessagePublishInfo _messagePublishInfo;
    private ContentHeaderBody _contentHeaderBody;
    private AMQMessageHandle _messageHandle;
    private final Long _messageId;
    private final TransactionalContext _txnContext;
    private static final boolean MSG_AUTH = ApplicationRegistry.getInstance().getConfiguration().getMsgAuth();
    private long _bodyLengthReceived = 0L;
    private ArrayList<AMQQueue> _destinationQueues;
    private AMQProtocolSession _publisher;
    private MessageStore _messageStore;
    private long _expiration;
    private Exchange _exchange;

    public IncomingMessage(Long messageId, MessagePublishInfo info, TransactionalContext txnContext, AMQProtocolSession publisher) {
        this._messageId = messageId;
        this._messagePublishInfo = info;
        this._txnContext = txnContext;
        this._publisher = publisher;
    }

    public void setContentHeaderBody(ContentHeaderBody contentHeaderBody) throws AMQException {
        this._contentHeaderBody = contentHeaderBody;
    }

    public void setExpiration() {
        long diff;
        long expiration = ((BasicContentHeaderProperties)this._contentHeaderBody.properties).getExpiration();
        long timestamp = ((BasicContentHeaderProperties)this._contentHeaderBody.properties).getTimestamp();
        if (SYNCHED_CLOCKS) {
            this._expiration = expiration;
        } else if (expiration != 0L && timestamp != 0L && ((diff = System.currentTimeMillis() - timestamp) > 1000L || diff < 1000L)) {
            this._expiration = expiration + diff;
        }
    }

    public void routingComplete(MessageStore store, MessageHandleFactory factory) throws AMQException {
        boolean persistent = this.isPersistent();
        this._messageHandle = factory.createMessageHandle(this._messageId, store, persistent);
        if (persistent) {
            this._txnContext.beginTranIfNecessary();
            if (this._destinationQueues != null) {
                for (int i = 0; i < this._destinationQueues.size(); ++i) {
                    store.enqueueMessage(this._txnContext.getStoreContext(), this._destinationQueues.get(i), this._messageId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQMessage deliverToQueues() throws AMQException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Delivering message " + this._messageId + " to " + this._destinationQueues));
        }
        AMQMessage message = null;
        try {
            AMQShortString userID;
            this._messageHandle.setPublishAndContentHeaderBody(this._txnContext.getStoreContext(), this._messagePublishInfo, this.getContentHeaderBody());
            message = new AMQMessage(this._messageHandle, this._txnContext.getStoreContext(), this._messagePublishInfo);
            message.setExpiration(this._expiration);
            message.setClientIdentifier(this._publisher.getSessionIdentifier());
            this._txnContext.messageFullyReceived(this.isPersistent());
            AMQShortString aMQShortString = userID = this.getContentHeaderBody().properties instanceof BasicContentHeaderProperties ? ((BasicContentHeaderProperties)this.getContentHeaderBody().properties).getUserId() : null;
            if (MSG_AUTH && !this._publisher.getAuthorizedID().getName().equals(userID == null ? "" : userID.toString())) {
                throw new UnauthorizedAccessException("Acccess Refused", message);
            }
            if (this._destinationQueues == null || this._destinationQueues.size() == 0) {
                if (this.isMandatory() || this.isImmediate()) {
                    throw new NoRouteException("No Route for message", message);
                }
                _logger.warn((Object)("MESSAGE DISCARDED: No routes for message - " + message));
            } else {
                int i;
                int offset;
                int queueCount = this._destinationQueues.size();
                message.incrementReference(queueCount);
                if (queueCount == 1) {
                    offset = 0;
                } else {
                    offset = (int)message.getMessageId().longValue() % queueCount;
                    if (offset < 0) {
                        offset = -offset;
                    }
                }
                for (i = offset; i < queueCount; ++i) {
                    this._txnContext.deliver(this._destinationQueues.get(i), message);
                }
                for (i = 0; i < offset; ++i) {
                    this._txnContext.deliver(this._destinationQueues.get(i), message);
                }
            }
            message.clearStoreContext();
            AMQMessage aMQMessage = message;
            return aMQMessage;
        }
        finally {
            if (message != null) {
                message.decrementReference(this._txnContext.getStoreContext());
            }
        }
    }

    public void addContentBodyFrame(ContentChunk contentChunk) throws AMQException {
        this._bodyLengthReceived += (long)contentChunk.getSize();
        this._messageHandle.addContentBodyFrame(this._txnContext.getStoreContext(), contentChunk, this.allContentReceived());
    }

    public boolean allContentReceived() {
        return this._bodyLengthReceived == this.getContentHeaderBody().bodySize;
    }

    public AMQShortString getExchange() throws AMQException {
        return this._messagePublishInfo.getExchange();
    }

    public AMQShortString getRoutingKey() throws AMQException {
        return this._messagePublishInfo.getRoutingKey();
    }

    public boolean isMandatory() throws AMQException {
        return this._messagePublishInfo.isMandatory();
    }

    public boolean isImmediate() throws AMQException {
        return this._messagePublishInfo.isImmediate();
    }

    @Override
    public ContentHeaderBody getContentHeaderBody() {
        return this._contentHeaderBody;
    }

    @Override
    public boolean isPersistent() {
        return this.getContentHeaderBody().properties instanceof BasicContentHeaderProperties && ((BasicContentHeaderProperties)this.getContentHeaderBody().properties).getDeliveryMode() == 2;
    }

    @Override
    public boolean isRedelivered() {
        return false;
    }

    public void setMessageStore(MessageStore messageStore) {
        this._messageStore = messageStore;
    }

    public Long getMessageId() {
        return this._messageId;
    }

    public void setExchange(Exchange e) {
        this._exchange = e;
    }

    public void route() throws AMQException {
        this._exchange.route(this);
    }

    public void enqueue(ArrayList<AMQQueue> queues) {
        this._destinationQueues = queues;
    }
}

