/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.io.IOException;
import javax.management.JMException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.management.MBeanAttribute;
import org.apache.qpid.server.management.MBeanOperation;
import org.apache.qpid.server.management.MBeanOperationParameter;

public interface ManagedQueue {
    public static final String TYPE = "Queue";
    public static final int VERSION = 2;

    @MBeanAttribute(name="Name", description="Queue Name")
    public String getName() throws IOException;

    @MBeanAttribute(name="MessageCount", description="Total number of undelivered messages on the queue")
    public Integer getMessageCount() throws IOException;

    @MBeanAttribute(name="ReceivedMessageCount", description="The total number of messages receieved by the queue since startup")
    public Long getReceivedMessageCount() throws IOException;

    @MBeanAttribute(name="QueueDepth", description="The total size(Bytes) of messages in the queue")
    public Long getQueueDepth() throws IOException, JMException;

    @MBeanAttribute(name="ActiveConsumerCount", description="The total number of active subscribers to the queue")
    public Integer getActiveConsumerCount() throws IOException;

    @MBeanAttribute(name="ConsumerCount", description="The total number of subscribers to the queue")
    public Integer getConsumerCount() throws IOException;

    @MBeanAttribute(name="Owner", description="Owner")
    public String getOwner() throws IOException;

    @MBeanAttribute(name="Durable", description="true if the AMQQueue is durable")
    public boolean isDurable() throws IOException;

    @MBeanAttribute(name="AutoDelete", description="true if the AMQQueue is AutoDelete")
    public boolean isAutoDelete() throws IOException;

    public Long getMaximumMessageAge() throws IOException;

    @MBeanAttribute(name="MaximumMessageAge", description="Threshold high value(milliseconds) for message age")
    public void setMaximumMessageAge(Long var1) throws IOException;

    public Long getMaximumMessageSize() throws IOException;

    @MBeanAttribute(name="MaximumMessageSize", description="Threshold high value(Bytes) for a message size")
    public void setMaximumMessageSize(Long var1) throws IOException;

    public Long getMaximumMessageCount() throws IOException;

    @MBeanAttribute(name="MaximumMessageCount", description="Threshold high value for number of undelivered messages in the queue")
    public void setMaximumMessageCount(Long var1) throws IOException;

    public Long getMaximumQueueDepth() throws IOException;

    @MBeanAttribute(name="MaximumQueueDepth", description="The threshold high value(Bytes) for Queue Depth")
    public void setMaximumQueueDepth(Long var1) throws IOException;

    @MBeanOperation(name="viewMessages", description="Message headers for messages in this queue within given index range. eg. from index 1 - 100")
    public TabularData viewMessages(@MBeanOperationParameter(name="from index", description="from index") int var1, @MBeanOperationParameter(name="to index", description="to index") int var2) throws IOException, JMException, AMQException;

    @MBeanOperation(name="viewMessageContent", description="The message content for given Message Id")
    public CompositeData viewMessageContent(@MBeanOperationParameter(name="Message Id", description="Message Id") long var1) throws IOException, JMException;

    @MBeanOperation(name="deleteMessageFromTop", description="Deletes the first message from top", impact=1)
    public void deleteMessageFromTop() throws IOException, JMException;

    @MBeanOperation(name="clearQueue", description="Clears the queue by deleting all the undelivered messages from the queue", impact=1)
    public void clearQueue() throws IOException, JMException;

    @MBeanOperation(name="moveMessages", description="You can move messages to another queue from this queue ", impact=1)
    public void moveMessages(@MBeanOperationParameter(name="from MessageId", description="from MessageId") long var1, @MBeanOperationParameter(name="to MessageId", description="to MessageId") long var3, @MBeanOperationParameter(name="Queue", description="to Queue Name") String var5) throws IOException, JMException, AMQException;
}

