/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.CommonContentHeaderProperties;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryImpl;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.QueueEntryListFactory;
import org.apache.qpid.server.queue.SimpleQueueEntryList;

public class PriorityQueueList
implements QueueEntryList {
    private final AMQQueue _queue;
    private final QueueEntryList[] _priorityLists;
    private final int _priorities;
    private final int _priorityOffset;

    public PriorityQueueList(AMQQueue queue, int priorities) {
        this._queue = queue;
        this._priorityLists = new QueueEntryList[priorities];
        this._priorities = priorities;
        this._priorityOffset = 5 - (priorities + 1) / 2;
        for (int i = 0; i < priorities; ++i) {
            this._priorityLists[i] = new SimpleQueueEntryList(queue);
        }
    }

    public int getPriorities() {
        return this._priorities;
    }

    public AMQQueue getQueue() {
        return this._queue;
    }

    public QueueEntry add(AMQMessage message) {
        try {
            int index = ((CommonContentHeaderProperties)message.getContentHeaderBody().properties).getPriority() - this._priorityOffset;
            if (index >= this._priorities) {
                index = this._priorities - 1;
            } else if (index < 0) {
                index = 0;
            }
            return this._priorityLists[index].add(message);
        }
        catch (AMQException e) {
            throw new RuntimeException(e);
        }
    }

    public QueueEntry next(QueueEntry node) {
        QueueEntryImpl nodeImpl = (QueueEntryImpl)node;
        QueueEntryImpl next = nodeImpl.getNext();
        if (next == null) {
            QueueEntryList nodeEntryList = nodeImpl.getQueueEntryList();
            int index = this._priorityLists.length - 1;
            while (this._priorityLists[index] != nodeEntryList) {
                --index;
            }
            while (next == null && index != 0) {
                next = ((QueueEntryImpl)this._priorityLists[--index].getHead()).getNext();
            }
        }
        return next;
    }

    public QueueEntryIterator iterator() {
        return new PriorityQueueEntryListIterator();
    }

    public QueueEntry getHead() {
        return this._priorityLists[this._priorities - 1].getHead();
    }

    static class Factory
    implements QueueEntryListFactory {
        private final int _priorities;

        Factory(int priorities) {
            this._priorities = priorities;
        }

        public QueueEntryList createQueueEntryList(AMQQueue queue) {
            return new PriorityQueueList(queue, this._priorities);
        }
    }

    private final class PriorityQueueEntryListIterator
    implements QueueEntryIterator {
        private final QueueEntryIterator[] _iterators;
        private QueueEntry _lastNode;

        PriorityQueueEntryListIterator() {
            this._iterators = new QueueEntryIterator[PriorityQueueList.this._priorityLists.length];
            for (int i = 0; i < PriorityQueueList.this._priorityLists.length; ++i) {
                this._iterators[i] = PriorityQueueList.this._priorityLists[i].iterator();
            }
            this._lastNode = this._iterators[this._iterators.length - 1].getNode();
        }

        public boolean atTail() {
            for (int i = 0; i < this._iterators.length; ++i) {
                if (this._iterators[i].atTail()) continue;
                return false;
            }
            return true;
        }

        public QueueEntry getNode() {
            return this._lastNode;
        }

        public boolean advance() {
            for (int i = this._iterators.length - 1; i >= 0; --i) {
                if (!this._iterators[i].advance()) continue;
                this._lastNode = this._iterators[i].getNode();
                return true;
            }
            return false;
        }
    }
}

