/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.FailedDequeueException;
import org.apache.qpid.server.queue.MessageCleanupException;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.SimpleQueueEntryList;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.subscription.Subscription;

public class QueueEntryImpl
implements QueueEntry {
    private static final Logger _log = Logger.getLogger(QueueEntryImpl.class);
    private final SimpleQueueEntryList _queueEntryList;
    private AMQMessage _message;
    private Set<Subscription> _rejectedBy = null;
    private volatile QueueEntry.EntryState _state = AVAILABLE_STATE;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, QueueEntry.EntryState> _stateUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, QueueEntry.EntryState.class, "_state");
    private volatile Set<QueueEntry.StateChangeListener> _stateChangeListeners;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, Set> _listenersUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, Set.class, "_stateChangeListeners");
    private static final AtomicLongFieldUpdater<QueueEntryImpl> _entryIdUpdater = AtomicLongFieldUpdater.newUpdater(QueueEntryImpl.class, "_entryId");
    private volatile long _entryId;
    volatile QueueEntryImpl _next;

    QueueEntryImpl(SimpleQueueEntryList queueEntryList) {
        this(queueEntryList, null, Long.MIN_VALUE);
        this._state = DELETED_STATE;
    }

    public QueueEntryImpl(SimpleQueueEntryList queueEntryList, AMQMessage message, long entryId) {
        this._queueEntryList = queueEntryList;
        this._message = message;
        _entryIdUpdater.set(this, entryId);
    }

    public QueueEntryImpl(SimpleQueueEntryList queueEntryList, AMQMessage message) {
        this._queueEntryList = queueEntryList;
        this._message = message;
    }

    protected void setEntryId(long entryId) {
        _entryIdUpdater.set(this, entryId);
    }

    protected long getEntryId() {
        return this._entryId;
    }

    public AMQQueue getQueue() {
        return this._queueEntryList.getQueue();
    }

    public AMQMessage getMessage() {
        return this._message;
    }

    public long getSize() {
        return this.getMessage().getSize();
    }

    public boolean getDeliveredToConsumer() {
        return this.getMessage().getDeliveredToConsumer();
    }

    public boolean expired() throws AMQException {
        return this.getMessage().expired(this.getQueue());
    }

    public boolean isAcquired() {
        return this._state.getState() == QueueEntry.State.ACQUIRED;
    }

    public boolean acquire() {
        return this.acquire(NON_SUBSCRIPTION_ACQUIRED_STATE);
    }

    private boolean acquire(QueueEntry.EntryState state) {
        boolean acquired = _stateUpdater.compareAndSet(this, AVAILABLE_STATE, state);
        if (acquired && this._stateChangeListeners != null) {
            this.notifyStateChange(QueueEntry.State.AVAILABLE, QueueEntry.State.ACQUIRED);
        }
        return acquired;
    }

    public boolean acquire(Subscription sub) {
        return this.acquire(sub.getOwningState());
    }

    public boolean acquiredBySubscription() {
        return this._state instanceof QueueEntry.SubscriptionAcquiredState;
    }

    public void setDeliveredToSubscription() {
        this.getMessage().setDeliveredToConsumer();
    }

    public void release() {
        _stateUpdater.set(this, AVAILABLE_STATE);
    }

    public String debugIdentity() {
        return this.getMessage().debugIdentity();
    }

    public boolean immediateAndNotDelivered() {
        return this._message.immediateAndNotDelivered();
    }

    public void setRedelivered(boolean b) {
        this.getMessage().setRedelivered(b);
    }

    public Subscription getDeliveredSubscription() {
        QueueEntry.EntryState state = this._state;
        if (state instanceof QueueEntry.SubscriptionAcquiredState) {
            return ((QueueEntry.SubscriptionAcquiredState)state).getSubscription();
        }
        return null;
    }

    public void reject() {
        this.reject(this.getDeliveredSubscription());
    }

    public void reject(Subscription subscription) {
        if (subscription != null) {
            if (this._rejectedBy == null) {
                this._rejectedBy = new HashSet<Subscription>();
            }
            this._rejectedBy.add(subscription);
        } else {
            _log.warn((Object)("Requesting rejection by null subscriber:" + this.debugIdentity()));
        }
    }

    public boolean isRejectedBy(Subscription subscription) {
        if (this._rejectedBy != null) {
            return this._rejectedBy.contains(subscription);
        }
        return false;
    }

    public void requeue(StoreContext storeContext) throws AMQException {
        this.getQueue().requeue(storeContext, this);
        if (this._stateChangeListeners != null) {
            this.notifyStateChange(QueueEntry.State.ACQUIRED, QueueEntry.State.AVAILABLE);
        }
    }

    public void dequeue(StoreContext storeContext) throws FailedDequeueException {
        QueueEntry.EntryState state = this._state;
        if (state.getState() == QueueEntry.State.ACQUIRED && _stateUpdater.compareAndSet(this, state, DEQUEUED_STATE)) {
            if (state instanceof QueueEntry.SubscriptionAcquiredState) {
                Subscription s = ((QueueEntry.SubscriptionAcquiredState)state).getSubscription();
                s.restoreCredit(this);
            }
            this.getQueue().dequeue(storeContext, this);
            if (this._stateChangeListeners != null) {
                this.notifyStateChange(state.getState(), QueueEntry.State.DEQUEUED);
            }
        }
    }

    private void notifyStateChange(QueueEntry.State oldState, QueueEntry.State newState) {
        for (QueueEntry.StateChangeListener l : this._stateChangeListeners) {
            l.stateChanged(this, oldState, newState);
        }
    }

    public void dispose(StoreContext storeContext) throws MessageCleanupException {
        if (this.delete()) {
            this.getMessage().decrementReference(storeContext);
        }
    }

    public void discard(StoreContext storeContext) throws FailedDequeueException, MessageCleanupException {
        if (this.getQueue() != null) {
            this.dequeue(storeContext);
        }
        this.dispose(storeContext);
    }

    public boolean isQueueDeleted() {
        return this.getQueue().isDeleted();
    }

    public void addStateChangeListener(QueueEntry.StateChangeListener listener) {
        Set<QueueEntry.StateChangeListener> listeners = this._stateChangeListeners;
        if (listeners == null) {
            _listenersUpdater.compareAndSet(this, null, new CopyOnWriteArraySet());
            listeners = this._stateChangeListeners;
        }
        listeners.add(listener);
    }

    public boolean removeStateChangeListener(QueueEntry.StateChangeListener listener) {
        Set<QueueEntry.StateChangeListener> listeners = this._stateChangeListeners;
        if (listeners != null) {
            return listeners.remove(listener);
        }
        return false;
    }

    public int compareTo(QueueEntry o) {
        QueueEntryImpl other = (QueueEntryImpl)o;
        return this.getEntryId() > other.getEntryId() ? 1 : (this.getEntryId() < other.getEntryId() ? -1 : 0);
    }

    public QueueEntryImpl getNext() {
        QueueEntryImpl next = this.nextNode();
        while (next != null && next.isDeleted()) {
            QueueEntryImpl newNext = next.nextNode();
            if (newNext != null) {
                SimpleQueueEntryList._nextUpdater.compareAndSet(this, next, newNext);
                next = this.nextNode();
                continue;
            }
            next = null;
        }
        return next;
    }

    QueueEntryImpl nextNode() {
        return this._next;
    }

    public boolean isDeleted() {
        return this._state == DELETED_STATE;
    }

    public boolean delete() {
        QueueEntry.EntryState state = this._state;
        if (state != DELETED_STATE && _stateUpdater.compareAndSet(this, state, DELETED_STATE)) {
            this._queueEntryList.advanceHead();
            return true;
        }
        return false;
    }

    public QueueEntryList getQueueEntryList() {
        return this._queueEntryList;
    }
}

