/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryImpl;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.QueueEntryListFactory;

public class SimpleQueueEntryList
implements QueueEntryList {
    private final QueueEntryImpl _head;
    private volatile QueueEntryImpl _tail;
    static final AtomicReferenceFieldUpdater<SimpleQueueEntryList, QueueEntryImpl> _tailUpdater = AtomicReferenceFieldUpdater.newUpdater(SimpleQueueEntryList.class, QueueEntryImpl.class, "_tail");
    private final AMQQueue _queue;
    static final AtomicReferenceFieldUpdater<QueueEntryImpl, QueueEntryImpl> _nextUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, QueueEntryImpl.class, "_next");

    public SimpleQueueEntryList(AMQQueue queue) {
        this._queue = queue;
        this._tail = this._head = new QueueEntryImpl(this);
    }

    void advanceHead() {
        QueueEntryImpl head = this._head.nextNode();
        while (head._next != null && head.isDeleted()) {
            QueueEntryImpl newhead = head.nextNode();
            if (newhead != null) {
                _nextUpdater.compareAndSet(this._head, head, newhead);
            }
            head = this._head.nextNode();
        }
    }

    public AMQQueue getQueue() {
        return this._queue;
    }

    public QueueEntry add(AMQMessage message) {
        QueueEntryImpl node = new QueueEntryImpl(this, message);
        while (true) {
            QueueEntryImpl tail = this._tail;
            QueueEntryImpl next = tail.nextNode();
            if (tail != this._tail) continue;
            if (next == null) {
                node.setEntryId(tail.getEntryId() + 1L);
                if (!_nextUpdater.compareAndSet(tail, null, node)) continue;
                _tailUpdater.compareAndSet(this, tail, node);
                return node;
            }
            _tailUpdater.compareAndSet(this, tail, next);
        }
    }

    public QueueEntry next(QueueEntry node) {
        return ((QueueEntryImpl)node).getNext();
    }

    public QueueEntryIterator iterator() {
        return new QueueEntryIteratorImpl(this._head);
    }

    public QueueEntry getHead() {
        return this._head;
    }

    static class Factory
    implements QueueEntryListFactory {
        Factory() {
        }

        public QueueEntryList createQueueEntryList(AMQQueue queue) {
            return new SimpleQueueEntryList(queue);
        }
    }

    public class QueueEntryIteratorImpl
    implements QueueEntryIterator {
        private QueueEntryImpl _lastNode;

        QueueEntryIteratorImpl(QueueEntryImpl startNode) {
            this._lastNode = startNode;
        }

        public boolean atTail() {
            return this._lastNode.nextNode() == null;
        }

        public QueueEntry getNode() {
            return this._lastNode;
        }

        public boolean advance() {
            if (!this.atTail()) {
                QueueEntryImpl nextNode = this._lastNode.nextNode();
                while (nextNode.isDeleted() && nextNode.nextNode() != null) {
                    nextNode = nextNode.nextNode();
                }
                this._lastNode = nextNode;
                return true;
            }
            return false;
        }
    }
}

