/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.queue.AMQQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientMessageData {
    private MessagePublishInfo _messagePublishInfo;
    private ContentHeaderBody _contentHeaderBody;
    private long _bodyLengthReceived = 0L;
    private List<AMQQueue> _destinationQueues;

    public MessagePublishInfo getMessagePublishInfo() {
        return this._messagePublishInfo;
    }

    public void setMessagePublishInfo(MessagePublishInfo messagePublishInfo) {
        this._messagePublishInfo = messagePublishInfo;
    }

    public List<AMQQueue> getDestinationQueues() {
        return this._destinationQueues == null ? Collections.EMPTY_LIST : this._destinationQueues;
    }

    public void setDestinationQueues(List<AMQQueue> destinationQueues) {
        this._destinationQueues = destinationQueues;
    }

    public ContentHeaderBody getContentHeaderBody() {
        return this._contentHeaderBody;
    }

    public void setContentHeaderBody(ContentHeaderBody contentHeaderBody) {
        this._contentHeaderBody = contentHeaderBody;
    }

    public long getBodyLengthReceived() {
        return this._bodyLengthReceived;
    }

    public void addBodyLength(int value) {
        this._bodyLengthReceived += (long)value;
    }

    public boolean isAllContentReceived() throws AMQException {
        return this._bodyLengthReceived == this._contentHeaderBody.bodySize;
    }

    public void addDestinationQueue(AMQQueue queue) {
        if (this._destinationQueues == null) {
            this._destinationQueues = new ArrayList<AMQQueue>();
        }
        this._destinationQueues.add(queue);
    }

    public boolean isPersistent() {
        return this._contentHeaderBody.properties instanceof BasicContentHeaderProperties && ((BasicContentHeaderProperties)this._contentHeaderBody.properties).getDeliveryMode() == 2;
    }
}

