/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.queue.AMQMessageHandle;
import org.apache.qpid.server.queue.MessageMetaData;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreContext;

public class WeakReferenceMessageHandle
implements AMQMessageHandle {
    private WeakReference<ContentHeaderBody> _contentHeaderBody;
    private WeakReference<MessagePublishInfo> _messagePublishInfo;
    private List<WeakReference<ContentChunk>> _contentBodies;
    private boolean _redelivered;
    private final MessageStore _messageStore;
    private final Long _messageId;
    private long _arrivalTime;

    public WeakReferenceMessageHandle(Long messageId, MessageStore messageStore) {
        this._messageId = messageId;
        this._messageStore = messageStore;
    }

    public ContentHeaderBody getContentHeaderBody(StoreContext context) throws AMQException {
        ContentHeaderBody chb;
        ContentHeaderBody contentHeaderBody = chb = this._contentHeaderBody != null ? (ContentHeaderBody)this._contentHeaderBody.get() : null;
        if (chb == null) {
            MessageMetaData mmd = this.loadMessageMetaData(context);
            chb = mmd.getContentHeaderBody();
        }
        return chb;
    }

    public Long getMessageId() {
        return this._messageId;
    }

    private MessageMetaData loadMessageMetaData(StoreContext context) throws AMQException {
        MessageMetaData mmd = this._messageStore.getMessageMetaData(context, this._messageId);
        this.populateFromMessageMetaData(mmd);
        return mmd;
    }

    private void populateFromMessageMetaData(MessageMetaData mmd) {
        this._arrivalTime = mmd.getArrivalTime();
        this._contentHeaderBody = new WeakReference<ContentHeaderBody>(mmd.getContentHeaderBody());
        this._messagePublishInfo = new WeakReference<MessagePublishInfo>(mmd.getMessagePublishInfo());
    }

    public int getBodyCount(StoreContext context) throws AMQException {
        if (this._contentBodies == null) {
            MessageMetaData mmd = this._messageStore.getMessageMetaData(context, this._messageId);
            int chunkCount = mmd.getContentChunkCount();
            this._contentBodies = new ArrayList<WeakReference<ContentChunk>>(chunkCount);
            for (int i = 0; i < chunkCount; ++i) {
                this._contentBodies.add(new WeakReference<Object>(null));
            }
        }
        return this._contentBodies.size();
    }

    public long getBodySize(StoreContext context) throws AMQException {
        return this.getContentHeaderBody((StoreContext)context).bodySize;
    }

    public ContentChunk getContentChunk(StoreContext context, int index) throws AMQException, IllegalArgumentException {
        if (index > this._contentBodies.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of valid range 0 to " + (this._contentBodies.size() - 1));
        }
        WeakReference<ContentChunk> wr = this._contentBodies.get(index);
        ContentChunk cb = (ContentChunk)wr.get();
        if (cb == null) {
            cb = this._messageStore.getContentBodyChunk(context, this._messageId, index);
            this._contentBodies.set(index, new WeakReference<ContentChunk>(cb));
        }
        return cb;
    }

    public void addContentBodyFrame(StoreContext storeContext, ContentChunk contentChunk, boolean isLastContentBody) throws AMQException {
        if (this._contentBodies == null && isLastContentBody) {
            this._contentBodies = new ArrayList<WeakReference<ContentChunk>>(1);
        } else if (this._contentBodies == null) {
            this._contentBodies = new LinkedList<WeakReference<ContentChunk>>();
        }
        this._contentBodies.add(new WeakReference<ContentChunk>(contentChunk));
        this._messageStore.storeContentBodyChunk(storeContext, this._messageId, this._contentBodies.size() - 1, contentChunk, isLastContentBody);
    }

    public MessagePublishInfo getMessagePublishInfo(StoreContext context) throws AMQException {
        MessagePublishInfo bpb;
        MessagePublishInfo messagePublishInfo = bpb = this._messagePublishInfo != null ? (MessagePublishInfo)this._messagePublishInfo.get() : null;
        if (bpb == null) {
            MessageMetaData mmd = this.loadMessageMetaData(context);
            bpb = mmd.getMessagePublishInfo();
        }
        return bpb;
    }

    public boolean isRedelivered() {
        return this._redelivered;
    }

    public void setRedelivered(boolean redelivered) {
        this._redelivered = redelivered;
    }

    public boolean isPersistent() {
        return true;
    }

    public void setPublishAndContentHeaderBody(StoreContext storeContext, MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody) throws AMQException {
        if (contentHeaderBody.bodySize == 0L) {
            this._contentBodies = new LinkedList<WeakReference<ContentChunk>>();
        }
        long arrivalTime = System.currentTimeMillis();
        MessageMetaData mmd = new MessageMetaData(publishBody, contentHeaderBody, this._contentBodies.size(), arrivalTime);
        this._messageStore.storeMessageMetaData(storeContext, this._messageId, mmd);
        this.populateFromMessageMetaData(mmd);
    }

    public void removeMessage(StoreContext storeContext) throws AMQException {
        this._messageStore.removeMessage(storeContext, this._messageId);
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }
}

