/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.registry;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.mina.common.IoAcceptor;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.management.ManagedObjectRegistry;
import org.apache.qpid.server.plugins.PluginManager;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.access.ACLManager;
import org.apache.qpid.server.security.auth.database.PrincipalDatabaseManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

public abstract class ApplicationRegistry
implements IApplicationRegistry {
    protected static final Logger _logger = Logger.getLogger(ApplicationRegistry.class);
    private static Map<Integer, IApplicationRegistry> _instanceMap = new HashMap<Integer, IApplicationRegistry>();
    private final Map<Class<?>, Object> _configuredObjects = new HashMap();
    protected final ServerConfiguration _configuration;
    public static final int DEFAULT_INSTANCE = 1;
    public static final String DEFAULT_APPLICATION_REGISTRY = "org.apache.qpid.server.util.NullApplicationRegistry";
    public static String _APPLICATION_REGISTRY = "org.apache.qpid.server.util.NullApplicationRegistry";
    protected final Map<InetSocketAddress, IoAcceptor> _acceptors = new HashMap<InetSocketAddress, IoAcceptor>();
    protected ManagedObjectRegistry _managedObjectRegistry;
    protected AuthenticationManager _authenticationManager;
    protected VirtualHostRegistry _virtualHostRegistry;
    protected ACLManager _accessManager;
    protected PrincipalDatabaseManager _databaseManager;
    protected PluginManager _pluginManager;

    public static void initialise(IApplicationRegistry instance) throws Exception {
        ApplicationRegistry.initialise(instance, 1);
    }

    public static void initialise(IApplicationRegistry instance, int instanceID) throws Exception {
        if (instance != null) {
            _logger.info((Object)("Initialising Application Registry:" + instanceID));
            _instanceMap.put(instanceID, instance);
            try {
                instance.initialise();
            }
            catch (Exception e) {
                _instanceMap.remove(instanceID);
                throw e;
            }
        } else {
            ApplicationRegistry.remove(instanceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(int instanceID) {
        try {
            IApplicationRegistry instance = _instanceMap.get(instanceID);
            if (instance != null) {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)("Shuting down ApplicationRegistry(" + instanceID + "):" + instance));
                }
                instance.close();
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error shutting down Application Registry(" + instanceID + "): " + e), (Throwable)e);
        }
        finally {
            _instanceMap.remove(instanceID);
        }
    }

    public static void removeAll() {
        Object[] keys;
        for (Object k : keys = _instanceMap.keySet().toArray()) {
            ApplicationRegistry.remove((Integer)k);
        }
    }

    protected ApplicationRegistry(ServerConfiguration configuration) {
        this._configuration = configuration;
    }

    public static IApplicationRegistry getInstance() {
        return ApplicationRegistry.getInstance(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IApplicationRegistry getInstance(int instanceID) {
        Class<IApplicationRegistry> clazz = IApplicationRegistry.class;
        synchronized (IApplicationRegistry.class) {
            IApplicationRegistry instance = _instanceMap.get(instanceID);
            if (instance == null) {
                try {
                    _logger.info((Object)("Creating DEFAULT_APPLICATION_REGISTRY: " + _APPLICATION_REGISTRY + " : Instance:" + instanceID));
                    IApplicationRegistry registry = (IApplicationRegistry)Class.forName(_APPLICATION_REGISTRY).getConstructor(null).newInstance(null);
                    ApplicationRegistry.initialise(registry, instanceID);
                    _logger.info((Object)("Initialised Application Registry:" + instanceID));
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return registry;
                }
                catch (Exception e) {
                    _logger.error((Object)("Error configuring application: " + e), (Throwable)e);
                    throw new RuntimeException("Unable to create Application Registry", e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void close() throws Exception {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Shutting down ApplicationRegistry:" + this));
        }
        this.unbind();
        for (VirtualHost virtualHost : this.getVirtualHostRegistry().getVirtualHosts()) {
            virtualHost.close();
        }
        this._authenticationManager.close();
        if (this._managedObjectRegistry != null) {
            this._managedObjectRegistry.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() {
        Map<InetSocketAddress, IoAcceptor> map = this._acceptors;
        synchronized (map) {
            for (InetSocketAddress bindAddress : this._acceptors.keySet()) {
                IoAcceptor acceptor = this._acceptors.get(bindAddress);
                acceptor.unbind((SocketAddress)bindAddress);
            }
        }
    }

    public ServerConfiguration getConfiguration() {
        return this._configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAcceptor(InetSocketAddress bindAddress, IoAcceptor acceptor) {
        Map<InetSocketAddress, IoAcceptor> map = this._acceptors;
        synchronized (map) {
            this._acceptors.put(bindAddress, acceptor);
        }
    }

    public static void setDefaultApplicationRegistry(String clazz) {
        _APPLICATION_REGISTRY = clazz;
    }

    public VirtualHostRegistry getVirtualHostRegistry() {
        return this._virtualHostRegistry;
    }

    public ACLManager getAccessManager() throws ConfigurationException {
        return new ACLManager(this._configuration.getSecurityConfiguration(), this._pluginManager);
    }

    public ManagedObjectRegistry getManagedObjectRegistry() {
        return this._managedObjectRegistry;
    }

    public PrincipalDatabaseManager getDatabaseManager() {
        return this._databaseManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this._authenticationManager;
    }

    public PluginManager getPluginManager() {
        return this._pluginManager;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownService()));
    }

    private static class ShutdownService
    implements Runnable {
        private ShutdownService() {
        }

        public void run() {
            ApplicationRegistry.removeAll();
        }
    }
}

