/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.registry;

import java.io.File;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.management.JMXManagedObjectRegistry;
import org.apache.qpid.server.management.NoopManagedObjectRegistry;
import org.apache.qpid.server.plugins.PluginManager;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.security.access.ACLManager;
import org.apache.qpid.server.security.auth.database.ConfigurationFilePrincipalDatabaseManager;
import org.apache.qpid.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

public class ConfigurationFileApplicationRegistry
extends ApplicationRegistry {
    public ConfigurationFileApplicationRegistry(File configurationURL) throws ConfigurationException {
        super(new ServerConfiguration(configurationURL));
    }

    public void initialise() throws Exception {
        this.initialiseManagedObjectRegistry();
        this._virtualHostRegistry = new VirtualHostRegistry();
        this._pluginManager = new PluginManager(this._configuration.getPluginDirectory());
        this._accessManager = new ACLManager(this._configuration.getSecurityConfiguration(), this._pluginManager);
        this._databaseManager = new ConfigurationFilePrincipalDatabaseManager(this._configuration);
        this._authenticationManager = new PrincipalDatabaseAuthenticationManager(null, null);
        this._databaseManager.initialiseManagement(this._configuration);
        this._managedObjectRegistry.start();
        this.initialiseVirtualHosts();
    }

    private void initialiseVirtualHosts() throws Exception {
        for (String name : this._configuration.getVirtualHosts()) {
            this._virtualHostRegistry.registerVirtualHost(new VirtualHost(this._configuration.getVirtualHostConfig(name)));
        }
        this.getVirtualHostRegistry().setDefaultVirtualHostName(this._configuration.getDefaultVirtualHost());
    }

    private void initialiseManagedObjectRegistry() throws AMQException {
        this._managedObjectRegistry = this._configuration.getManagementEnabled() ? new JMXManagedObjectRegistry() : new NoopManagedObjectRegistry();
    }
}

