/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.configuration.SecurityConfiguration;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.plugins.PluginManager;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.security.access.ACLPlugin;
import org.apache.qpid.server.security.access.ACLPluginFactory;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLManager {
    private static final Logger _logger = Logger.getLogger(ACLManager.class);
    private PluginManager _pluginManager;
    private Map<String, ACLPluginFactory> _allSecurityPlugins = new HashMap<String, ACLPluginFactory>();
    private Map<String, ACLPlugin> _globalPlugins = new HashMap<String, ACLPlugin>();
    private Map<String, ACLPlugin> _hostPlugins = new HashMap<String, ACLPlugin>();

    public ACLManager(SecurityConfiguration configuration, PluginManager manager) throws ConfigurationException {
        this(configuration, manager, null);
    }

    public ACLManager(SecurityConfiguration configuration, PluginManager manager, ACLPluginFactory securityPlugin) throws ConfigurationException {
        this._pluginManager = manager;
        if (manager == null) {
            return;
        }
        this._allSecurityPlugins = this._pluginManager.getSecurityPlugins();
        if (securityPlugin != null) {
            this._allSecurityPlugins.put(securityPlugin.getClass().getName(), securityPlugin);
        }
        this._globalPlugins = this.configurePlugins(configuration);
    }

    public void configureHostPlugins(SecurityConfiguration hostConfig) throws ConfigurationException {
        this._hostPlugins = this.configurePlugins(hostConfig);
    }

    public Map<String, ACLPlugin> configurePlugins(SecurityConfiguration hostConfig) throws ConfigurationException {
        Configuration securityConfig = hostConfig.getConfiguration();
        HashMap<String, ACLPlugin> plugins = new HashMap<String, ACLPlugin>();
        Iterator keys = securityConfig.getKeys();
        HashSet<String> handledTags = new HashSet<String>();
        while (keys.hasNext()) {
            String tag = ((String)keys.next()).split("\\.", 2)[0];
            if (!handledTags.contains(tag)) {
                for (ACLPluginFactory plugin : this._allSecurityPlugins.values()) {
                    if (!plugin.supportsTag(tag)) continue;
                    _logger.warn((Object)("Plugin handling security section " + tag + " is " + plugin.getClass().getSimpleName()));
                    handledTags.add(tag);
                    plugins.put(plugin.getClass().getName(), plugin.newInstance(securityConfig));
                }
            }
            if (handledTags.contains(tag)) continue;
            _logger.warn((Object)("No plugin handled security section " + tag));
        }
        return plugins;
    }

    public static Logger getLogger() {
        return _logger;
    }

    private boolean checkAllPlugins(AccessCheck checker) {
        ACLPlugin.AuthzResult result = ACLPlugin.AuthzResult.ABSTAIN;
        HashMap<String, ACLPlugin> remainingPlugins = new HashMap<String, ACLPlugin>();
        remainingPlugins.putAll(this._globalPlugins);
        for (Map.Entry<String, ACLPlugin> entry : this._hostPlugins.entrySet()) {
            result = checker.allowed(entry.getValue());
            if (result == ACLPlugin.AuthzResult.DENIED) {
                return false;
            }
            if (result != ACLPlugin.AuthzResult.ALLOWED) continue;
            remainingPlugins.remove(entry.getKey());
        }
        for (ACLPlugin aCLPlugin : remainingPlugins.values()) {
            result = checker.allowed(aCLPlugin);
            if (result != ACLPlugin.AuthzResult.DENIED) continue;
            return false;
        }
        return true;
    }

    public boolean authoriseBind(final AMQProtocolSession session, final Exchange exch, final AMQQueue queue, final AMQShortString routingKey) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authoriseBind(session, exch, queue, routingKey);
            }
        });
    }

    public boolean authoriseConnect(final AMQProtocolSession session, final VirtualHost virtualHost) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authoriseConnect(session, virtualHost);
            }
        });
    }

    public boolean authoriseConsume(final AMQProtocolSession session, final boolean noAck, final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authoriseConsume(session, noAck, queue);
            }
        });
    }

    public boolean authoriseConsume(final AMQProtocolSession session, final boolean exclusive, final boolean noAck, final boolean noLocal, final boolean nowait, final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authoriseConsume(session, exclusive, noAck, noLocal, nowait, queue);
            }
        });
    }

    public boolean authoriseCreateExchange(final AMQProtocolSession session, final boolean autoDelete, final boolean durable, final AMQShortString exchangeName, final boolean internal, final boolean nowait, final boolean passive, final AMQShortString exchangeType) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authoriseCreateExchange(session, autoDelete, durable, exchangeName, internal, nowait, passive, exchangeType);
            }
        });
    }

    public boolean authoriseCreateQueue(final AMQProtocolSession session, final boolean autoDelete, final boolean durable, final boolean exclusive, final boolean nowait, final boolean passive, final AMQShortString queue) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authoriseCreateQueue(session, autoDelete, durable, exclusive, nowait, passive, queue);
            }
        });
    }

    public boolean authoriseDelete(final AMQProtocolSession session, final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authoriseDelete(session, queue);
            }
        });
    }

    public boolean authoriseDelete(final AMQProtocolSession session, final Exchange exchange) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authoriseDelete(session, exchange);
            }
        });
    }

    public boolean authorisePublish(final AMQProtocolSession session, final boolean immediate, final boolean mandatory, final AMQShortString routingKey, final Exchange e) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authorisePublish(session, immediate, mandatory, routingKey, e);
            }
        });
    }

    public boolean authorisePurge(final AMQProtocolSession session, final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authorisePurge(session, queue);
            }
        });
    }

    public boolean authoriseUnbind(final AMQProtocolSession session, final Exchange exch, final AMQShortString routingKey, final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            ACLPlugin.AuthzResult allowed(ACLPlugin plugin) {
                return plugin.authoriseUnbind(session, exch, routingKey, queue);
            }
        });
    }

    public void addHostPlugin(ACLPlugin aclPlugin) {
        this._hostPlugins.put(aclPlugin.getClass().getName(), aclPlugin);
    }

    private abstract class AccessCheck {
        private AccessCheck() {
        }

        abstract ACLPlugin.AuthzResult allowed(ACLPlugin var1);
    }
}

