/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.security.access.ACLPlugin;
import org.apache.qpid.server.security.access.Permission;

public class PrincipalPermissions {
    private static final Object CONSUME_QUEUES_KEY = new Object();
    private static final Object CONSUME_TEMPORARY_KEY = new Object();
    private static final Object CONSUME_OWN_QUEUES_ONLY_KEY = new Object();
    private static final Object CREATE_QUEUES_KEY = new Object();
    private static final Object CREATE_EXCHANGES_KEY = new Object();
    private static final Object CREATE_QUEUE_TEMPORARY_KEY = new Object();
    private static final Object CREATE_QUEUE_QUEUES_KEY = new Object();
    private static final Object CREATE_QUEUE_EXCHANGES_KEY = new Object();
    private static final Object CREATE_QUEUE_EXCHANGES_TEMPORARY_KEY = new Object();
    private static final Object CREATE_QUEUE_EXCHANGES_ROUTINGKEYS_KEY = new Object();
    private static final int PUBLISH_EXCHANGES_KEY = 0;
    private Map _permissions;
    private String _user;

    public PrincipalPermissions(String user) {
        this._user = user;
        this._permissions = new ConcurrentHashMap();
    }

    public void grant(Permission permission, Object ... parameters) {
        switch (permission) {
            case ACCESS: {
                break;
            }
            case BIND: {
                break;
            }
            case CONSUME: {
                ConcurrentHashMap<Object, Serializable> consumeRights = (ConcurrentHashMap<Object, Serializable>)this._permissions.get((Object)permission);
                if (consumeRights == null) {
                    consumeRights = new ConcurrentHashMap<Object, Serializable>();
                    this._permissions.put(permission, consumeRights);
                }
                if (parameters.length <= 0) break;
                AMQShortString queueName = (AMQShortString)parameters[0];
                Boolean temporary = (Boolean)parameters[1];
                Boolean ownQueueOnly = (Boolean)parameters[2];
                if (temporary.booleanValue()) {
                    consumeRights.put(CONSUME_TEMPORARY_KEY, Boolean.valueOf(true));
                } else {
                    consumeRights.put(CONSUME_TEMPORARY_KEY, Boolean.valueOf(false));
                }
                if (ownQueueOnly.booleanValue()) {
                    consumeRights.put(CONSUME_OWN_QUEUES_ONLY_KEY, Boolean.valueOf(true));
                } else {
                    consumeRights.put(CONSUME_OWN_QUEUES_ONLY_KEY, Boolean.valueOf(false));
                }
                LinkedList<AMQShortString> queues = (LinkedList<AMQShortString>)consumeRights.get(CONSUME_QUEUES_KEY);
                if (queues == null) {
                    queues = new LinkedList<AMQShortString>();
                    consumeRights.put(CONSUME_QUEUES_KEY, queues);
                }
                if (queueName == null) break;
                queues.add(queueName);
                break;
            }
            case CREATEQUEUE: {
                ConcurrentHashMap<AMQShortString, ConcurrentHashMap<Object, Boolean>> create_queues_exchanges;
                ConcurrentHashMap<Object, ConcurrentHashMap<Object, Boolean>> createRights = (ConcurrentHashMap<Object, ConcurrentHashMap<Object, Boolean>>)this._permissions.get((Object)permission);
                if (createRights == null) {
                    createRights = new ConcurrentHashMap<Object, ConcurrentHashMap<Object, Boolean>>();
                    this._permissions.put(permission, createRights);
                }
                if (parameters.length == 0) {
                    return;
                }
                Boolean temporary = (Boolean)parameters[0];
                AMQShortString queueName = parameters.length > 1 ? (AMQShortString)parameters[1] : null;
                AMQShortString exchangeName = parameters.length > 2 ? (AMQShortString)parameters[2] : null;
                AMQShortString routingKey = parameters.length > 3 && null != parameters[3] ? (AMQShortString)parameters[3] : queueName;
                ConcurrentHashMap<Object, Boolean> create_queues = (ConcurrentHashMap<Object, Boolean>)createRights.get(CREATE_QUEUES_KEY);
                if (create_queues == null) {
                    create_queues = new ConcurrentHashMap<Object, Boolean>();
                    createRights.put(CREATE_QUEUES_KEY, create_queues);
                }
                create_queues.put(CREATE_QUEUE_TEMPORARY_KEY, temporary);
                ConcurrentHashMap<AMQShortString, ConcurrentHashMap<AMQShortString, AMQShortString>> create_queues_queues = (ConcurrentHashMap<AMQShortString, ConcurrentHashMap<AMQShortString, AMQShortString>>)create_queues.get(CREATE_QUEUE_QUEUES_KEY);
                if (create_queues_queues == null) {
                    create_queues_queues = new ConcurrentHashMap<AMQShortString, ConcurrentHashMap<AMQShortString, AMQShortString>>();
                    create_queues.put(CREATE_QUEUE_QUEUES_KEY, (Boolean)((Object)create_queues_queues));
                }
                if (parameters.length == 1) {
                    return;
                }
                if (queueName != null) {
                    ConcurrentHashMap<AMQShortString, AMQShortString> queue = (ConcurrentHashMap<AMQShortString, AMQShortString>)create_queues_queues.get(queueName);
                    if (queue == null) {
                        queue = new ConcurrentHashMap<AMQShortString, AMQShortString>();
                        create_queues_queues.put(queueName, queue);
                    }
                    if (exchangeName != null) {
                        queue.put(exchangeName, routingKey);
                    }
                }
                if ((create_queues_exchanges = (ConcurrentHashMap<AMQShortString, ConcurrentHashMap<Object, Boolean>>)create_queues.get(CREATE_QUEUE_EXCHANGES_KEY)) == null) {
                    create_queues_exchanges = new ConcurrentHashMap<AMQShortString, ConcurrentHashMap<Object, Boolean>>();
                    create_queues.put(CREATE_QUEUE_EXCHANGES_KEY, (Boolean)((Object)create_queues_exchanges));
                }
                if (exchangeName == null) break;
                ConcurrentHashMap<Object, Boolean> exchanges = (ConcurrentHashMap<Object, Boolean>)create_queues_exchanges.get(exchangeName);
                if (exchanges == null) {
                    exchanges = new ConcurrentHashMap<Object, Boolean>();
                    create_queues_exchanges.put(exchangeName, exchanges);
                }
                exchanges.put(CREATE_QUEUE_EXCHANGES_TEMPORARY_KEY, temporary);
                if (queueName == null) break;
                ConcurrentHashMap<AMQShortString, AMQShortString> rKeys = (ConcurrentHashMap<AMQShortString, AMQShortString>)exchanges.get(exchangeName);
                if (rKeys == null) {
                    rKeys = new ConcurrentHashMap<AMQShortString, AMQShortString>();
                    exchanges.put(CREATE_QUEUE_EXCHANGES_ROUTINGKEYS_KEY, (Boolean)((Object)rKeys));
                }
                rKeys.put(queueName, routingKey);
                break;
            }
            case CREATEEXCHANGE: {
                ConcurrentHashMap create_exchanges;
                ConcurrentHashMap rights = (ConcurrentHashMap)this._permissions.get((Object)permission);
                if (rights == null) {
                    rights = new ConcurrentHashMap();
                    this._permissions.put(permission, rights);
                }
                if ((create_exchanges = (ConcurrentHashMap)rights.get(CREATE_EXCHANGES_KEY)) == null) {
                    create_exchanges = new ConcurrentHashMap();
                    rights.put(CREATE_EXCHANGES_KEY, create_exchanges);
                }
                AMQShortString name = parameters.length > 0 ? (AMQShortString)parameters[0] : null;
                AMQShortString className = parameters.length > 1 ? (AMQShortString)parameters[1] : new AMQShortString("direct");
                rights.put(name, className);
                break;
            }
            case DELETE: {
                break;
            }
            case PUBLISH: {
                ConcurrentHashMap publishRights = (ConcurrentHashMap)this._permissions.get((Object)permission);
                if (publishRights == null) {
                    publishRights = new ConcurrentHashMap();
                    this._permissions.put(permission, publishRights);
                }
                if (parameters == null || parameters.length == 0) break;
                ConcurrentHashMap<Object, HashSet<Object>> publish_exchanges = (ConcurrentHashMap<Object, HashSet<Object>>)publishRights.get(0);
                if (publish_exchanges == null) {
                    publish_exchanges = new ConcurrentHashMap<Object, HashSet<Object>>();
                    publishRights.put(0, publish_exchanges);
                }
                HashSet<Object> routingKeys = (HashSet<Object>)publish_exchanges.get(parameters[0]);
                if (parameters.length == 2) {
                    if (routingKeys == null) {
                        routingKeys = new HashSet<Object>();
                    }
                    routingKeys.add(parameters[1]);
                }
                publish_exchanges.put(parameters[0], routingKeys);
                break;
            }
            case PURGE: {
                break;
            }
        }
    }

    public ACLPlugin.AuthzResult authorise(Permission permission, Object ... parameters) {
        switch (permission) {
            case ACCESS: {
                return ACLPlugin.AuthzResult.ALLOWED;
            }
            case BIND: {
                Map bind_exchanges;
                Exchange exchange = (Exchange)parameters[1];
                AMQQueue bind_queueName = (AMQQueue)parameters[2];
                AMQShortString routingKey = (AMQShortString)parameters[3];
                Map bindCreateRights = (Map)this._permissions.get((Object)Permission.CREATEQUEUE);
                Map bind_create_queues = (Map)bindCreateRights.get(CREATE_QUEUES_KEY);
                Map bind_create_queues_queues = (Map)bindCreateRights.get(CREATE_QUEUE_QUEUES_KEY);
                if (bind_create_queues_queues != null) {
                    Map exchangeDetails = (Map)bind_create_queues_queues.get(bind_queueName);
                    if (exchangeDetails == null) {
                        return ACLPlugin.AuthzResult.ALLOWED;
                    }
                    Map rkeys = (Map)exchangeDetails.get(exchange.getName());
                    if (rkeys == null) {
                        return ACLPlugin.AuthzResult.ALLOWED;
                    }
                    Iterator keys = rkeys.keySet().iterator();
                    boolean matched = false;
                    while (keys.hasNext() && !matched) {
                        AMQShortString rkey = (AMQShortString)keys.next();
                        if (rkey.endsWith("*")) {
                            matched = routingKey.startsWith(((Object)rkey.subSequence(0, rkey.length() - 1)).toString());
                            continue;
                        }
                        matched = routingKey.equals(rkey);
                    }
                    return matched ? ACLPlugin.AuthzResult.ALLOWED : ACLPlugin.AuthzResult.DENIED;
                }
                if (bind_queueName.isAutoDelete() && (bind_exchanges = (Map)bind_create_queues.get(CREATE_QUEUE_EXCHANGES_KEY)) != null) {
                    Map exchangeDetails = (Map)bind_exchanges.get(exchange.getName());
                    return (Boolean)exchangeDetails.get(CREATE_QUEUE_EXCHANGES_TEMPORARY_KEY) != false ? ACLPlugin.AuthzResult.ALLOWED : ACLPlugin.AuthzResult.DENIED;
                }
                return ACLPlugin.AuthzResult.ALLOWED;
            }
            case CREATEQUEUE: {
                Map createRights = (Map)this._permissions.get((Object)permission);
                if (createRights == null) {
                    return ACLPlugin.AuthzResult.DENIED;
                }
                Map create_queues = (Map)createRights.get(CREATE_QUEUES_KEY);
                Map create_queues_queues = (Map)create_queues.get(CREATE_QUEUE_QUEUES_KEY);
                AMQShortString queueName = (AMQShortString)parameters[1];
                Boolean autoDelete = (Boolean)parameters[0];
                if (autoDelete.booleanValue()) {
                    return (Boolean)create_queues.get(CREATE_QUEUE_TEMPORARY_KEY) != false ? ACLPlugin.AuthzResult.ALLOWED : ACLPlugin.AuthzResult.DENIED;
                }
                if (create_queues_queues == null || create_queues_queues.containsKey(queueName)) {
                    return ACLPlugin.AuthzResult.ALLOWED;
                }
                return ACLPlugin.AuthzResult.DENIED;
            }
            case CREATEEXCHANGE: {
                Map rights = (Map)this._permissions.get((Object)permission);
                AMQShortString exchangeName = (AMQShortString)parameters[0];
                if (rights == null || rights.containsKey(exchangeName)) {
                    return ACLPlugin.AuthzResult.ALLOWED;
                }
                return ACLPlugin.AuthzResult.DENIED;
            }
            case CONSUME: {
                if (parameters.length == 1 && parameters[0] instanceof AMQQueue) {
                    AMQQueue queue = (AMQQueue)parameters[0];
                    Map queuePermissions = (Map)this._permissions.get((Object)permission);
                    List queues = (List)queuePermissions.get(CONSUME_QUEUES_KEY);
                    Boolean temporayQueues = (Boolean)queuePermissions.get(CONSUME_TEMPORARY_KEY);
                    Boolean ownQueuesOnly = (Boolean)queuePermissions.get(CONSUME_OWN_QUEUES_ONLY_KEY);
                    if (temporayQueues.booleanValue()) {
                        if (queue.isAutoDelete()) {
                            return ownQueuesOnly == false || queue.getOwner().equals((CharSequence)this._user) ? ACLPlugin.AuthzResult.ALLOWED : ACLPlugin.AuthzResult.DENIED;
                        }
                        return ACLPlugin.AuthzResult.DENIED;
                    }
                    if (queues != null) {
                        if (ownQueuesOnly.booleanValue()) {
                            if (queue.getOwner().equals((CharSequence)this._user)) {
                                return queues.size() == 0 || queues.contains(queue.getName()) ? ACLPlugin.AuthzResult.ALLOWED : ACLPlugin.AuthzResult.DENIED;
                            }
                            return ACLPlugin.AuthzResult.DENIED;
                        }
                        return queues.size() == 0 || queues.contains(queue.getName()) ? ACLPlugin.AuthzResult.ALLOWED : ACLPlugin.AuthzResult.DENIED;
                    }
                }
                return ACLPlugin.AuthzResult.DENIED;
            }
            case DELETE: {
                break;
            }
            case PUBLISH: {
                Map publishRights = (Map)this._permissions.get((Object)permission);
                if (publishRights == null) {
                    return ACLPlugin.AuthzResult.DENIED;
                }
                Map exchanges = (Map)publishRights.get(0);
                if (exchanges == null) {
                    return ACLPlugin.AuthzResult.ALLOWED;
                }
                if (!exchanges.containsKey(((Exchange)parameters[0]).getName())) {
                    return ACLPlugin.AuthzResult.DENIED;
                }
                HashSet routingKeys = (HashSet)exchanges.get(((Exchange)parameters[0]).getName());
                if (routingKeys == null) {
                    return ACLPlugin.AuthzResult.ALLOWED;
                }
                Iterator keys = routingKeys.iterator();
                AMQShortString publishRKey = (AMQShortString)parameters[1];
                boolean matched = false;
                while (keys.hasNext() && !matched) {
                    AMQShortString rkey = (AMQShortString)keys.next();
                    if (rkey.endsWith("*")) {
                        matched = publishRKey.startsWith(rkey.subSequence(0, rkey.length() - 1));
                        continue;
                    }
                    matched = publishRKey.equals(rkey);
                }
                return matched ? ACLPlugin.AuthzResult.ALLOWED : ACLPlugin.AuthzResult.DENIED;
            }
            case PURGE: {
                break;
            }
        }
        return ACLPlugin.AuthzResult.DENIED;
    }
}

