/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import org.apache.commons.configuration.Configuration;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.security.access.ACLManager;
import org.apache.qpid.server.security.access.ACLPlugin;
import org.apache.qpid.server.security.access.ACLPluginFactory;
import org.apache.qpid.server.security.access.AccessResult;
import org.apache.qpid.server.security.access.Permission;
import org.apache.qpid.server.security.access.plugins.BasicACLPlugin;

public class DenyAll
extends BasicACLPlugin {
    public static final ACLPluginFactory FACTORY = new ACLPluginFactory(){

        public boolean supportsTag(String name) {
            return false;
        }

        public ACLPlugin newInstance(Configuration config) {
            return new DenyAll();
        }
    };

    public AccessResult authorise(AMQProtocolSession session, Permission permission, AMQMethodBody body, Object ... parameters) throws AMQConnectionException {
        if (ACLManager.getLogger().isInfoEnabled()) {
            ACLManager.getLogger().info((Object)("Denying user:" + session.getAuthorizedID()));
        }
        throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "DenyAll Plugin");
    }

    public String getPluginName() {
        return this.getClass().getSimpleName();
    }

    protected ACLPlugin.AuthzResult getResult() {
        return ACLPlugin.AuthzResult.DENIED;
    }
}

