/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.security.access.ACLPlugin;
import org.apache.qpid.server.security.access.ACLPluginFactory;
import org.apache.qpid.server.security.access.AccessResult;
import org.apache.qpid.server.security.access.Permission;
import org.apache.qpid.server.security.access.PrincipalPermissions;
import org.apache.qpid.server.virtualhost.VirtualHost;

public class SimpleXML
implements ACLPlugin {
    public static final ACLPluginFactory FACTORY = new ACLPluginFactory(){

        public boolean supportsTag(String name) {
            return name.startsWith("access_control_list");
        }

        public ACLPlugin newInstance(Configuration config) {
            SimpleXML plugin = new SimpleXML();
            plugin.setConfiguration(config);
            return plugin;
        }
    };
    private Map<String, PrincipalPermissions> _users;
    private final AccessResult GRANTED = new AccessResult(this, AccessResult.AccessStatus.GRANTED);

    public SimpleXML() {
        this._users = new ConcurrentHashMap<String, PrincipalPermissions>();
    }

    public void setConfiguration(Configuration config) {
        this.processConfig(config);
    }

    private void processConfig(Configuration config) {
        this.processPublish(config);
        this.processConsume(config);
        this.processCreate(config);
    }

    private void processPublish(Configuration config) {
        String[] users;
        Configuration publishConfig = config.subset("access_control_list.publish");
        for (String user : users = publishConfig.getStringArray("users.user")) {
            this.grant(Permission.PUBLISH, user, new Object[0]);
        }
        int exchangeCount = 0;
        Configuration exchangeConfig = publishConfig.subset("exchanges.exchange(" + exchangeCount + ")");
        while (!exchangeConfig.isEmpty()) {
            AMQShortString exchangeName = new AMQShortString(exchangeConfig.getString("name"));
            int keyCount = 0;
            Configuration routingkeyConfig = exchangeConfig.subset("routing_keys.routing_key(" + keyCount + ")");
            while (!routingkeyConfig.isEmpty()) {
                AMQShortString routingKeyValue = new AMQShortString(routingkeyConfig.getString("value"));
                for (String user : users = routingkeyConfig.getStringArray("users.user")) {
                    this.grant(Permission.PUBLISH, user, exchangeName, routingKeyValue);
                }
                routingkeyConfig = exchangeConfig.subset("routing_keys.routing_key(" + ++keyCount + ")");
            }
            for (String user : users = exchangeConfig.getStringArray("exchange(" + exchangeCount + ").users.user")) {
                this.grant(Permission.PUBLISH, user, exchangeName);
            }
            exchangeConfig = publishConfig.subset("exchanges.exchange(" + ++exchangeCount + ")");
        }
    }

    private void grant(Permission permission, String user, Object ... parameters) {
        PrincipalPermissions permissions = this._users.get(user);
        if (permissions == null) {
            permissions = new PrincipalPermissions(user);
        }
        this._users.put(user, permissions);
        permissions.grant(permission, parameters);
    }

    private void processConsume(Configuration config) {
        String[] users;
        Configuration consumeConfig = config.subset("access_control_list.consume");
        int queueCount = 0;
        Configuration queueConfig = consumeConfig.subset("queues.queue(" + queueCount + ")");
        while (!queueConfig.isEmpty()) {
            String[] users2;
            AMQShortString queueName = new AMQShortString(queueConfig.getString("name"));
            boolean temporary = queueConfig.containsKey("temporary");
            boolean ownQueues = queueConfig.containsKey("own_queues");
            for (String user : users2 = queueConfig.getStringArray("users.user")) {
                this.grant(Permission.CONSUME, user, queueName, temporary, ownQueues);
            }
            queueConfig = consumeConfig.subset("queues.queue(" + ++queueCount + ")");
        }
        for (String user : users = consumeConfig.getStringArray("users.user")) {
            this.grant(Permission.CONSUME, user, new Object[0]);
        }
    }

    private void processCreate(Configuration config) {
        String[] users;
        String[] users2;
        Configuration createConfig = config.subset("access_control_list.create");
        int queueCount = 0;
        Configuration queueConfig = createConfig.subset("queues.queue(" + queueCount + ")");
        while (!queueConfig.isEmpty()) {
            AMQShortString queueName = new AMQShortString(queueConfig.getString("name"));
            boolean temporary = queueConfig.containsKey("temporary");
            int exchangeCount = 0;
            Configuration exchangeConfig = queueConfig.subset("exchanges.exchange(" + exchangeCount + ")");
            while (!exchangeConfig.isEmpty()) {
                String[] users3;
                AMQShortString exchange = new AMQShortString(exchangeConfig.getString("name"));
                AMQShortString routingKey = new AMQShortString(exchangeConfig.getString("routing_key"));
                for (String user : users3 = exchangeConfig.getStringArray("users.user")) {
                    this.grant(Permission.CREATEEXCHANGE, user, exchange);
                    this.grant(Permission.CREATEQUEUE, user, temporary, queueName.equals((CharSequence)"") ? null : queueName, exchange.equals((CharSequence)"") ? null : exchange, routingKey.equals((CharSequence)"") ? null : routingKey);
                }
                exchangeConfig = queueConfig.subset("exchanges.exchange(" + ++exchangeCount + ")");
            }
            for (String user : users2 = queueConfig.getStringArray("users.user")) {
                this.grant(Permission.CREATEQUEUE, user, temporary, queueName);
            }
            queueConfig = createConfig.subset("queues.queue(" + ++queueCount + ")");
        }
        int exchangeCount = 0;
        Configuration exchangeConfig = createConfig.subset("exchanges.exchange(" + exchangeCount + ")");
        while (!exchangeConfig.isEmpty()) {
            AMQShortString exchange = new AMQShortString(exchangeConfig.getString("name"));
            AMQShortString clazz = new AMQShortString(exchangeConfig.getString("class"));
            for (String user : users2 = exchangeConfig.getStringArray("users.user")) {
                this.grant(Permission.CREATEEXCHANGE, user, exchange, clazz);
            }
            exchangeConfig = queueConfig.subset("exchanges.exchange(" + ++exchangeCount + ")");
        }
        for (String user : users = createConfig.getStringArray("users.user")) {
            this.grant(Permission.CREATEEXCHANGE, user, new Object[0]);
            this.grant(Permission.CREATEQUEUE, user, new Object[0]);
        }
    }

    public String getPluginName() {
        return "Simple";
    }

    public ACLPlugin.AuthzResult authoriseBind(AMQProtocolSession session, Exchange exch, AMQQueue queue, AMQShortString routingKey) {
        PrincipalPermissions principalPermissions = this._users.get(session.getAuthorizedID().getName());
        if (principalPermissions == null) {
            return ACLPlugin.AuthzResult.DENIED;
        }
        return principalPermissions.authorise(Permission.BIND, null, exch, queue, routingKey);
    }

    public ACLPlugin.AuthzResult authoriseConnect(AMQProtocolSession session, VirtualHost virtualHost) {
        PrincipalPermissions principalPermissions = this._users.get(session.getAuthorizedID().getName());
        if (principalPermissions == null) {
            return ACLPlugin.AuthzResult.DENIED;
        }
        return principalPermissions.authorise(Permission.ACCESS, new Object[0]);
    }

    public ACLPlugin.AuthzResult authoriseConsume(AMQProtocolSession session, boolean noAck, AMQQueue queue) {
        PrincipalPermissions principalPermissions = this._users.get(session.getAuthorizedID().getName());
        if (principalPermissions == null) {
            return ACLPlugin.AuthzResult.DENIED;
        }
        return principalPermissions.authorise(Permission.CONSUME, queue);
    }

    public ACLPlugin.AuthzResult authoriseConsume(AMQProtocolSession session, boolean exclusive, boolean noAck, boolean noLocal, boolean nowait, AMQQueue queue) {
        return this.authoriseConsume(session, noAck, queue);
    }

    public ACLPlugin.AuthzResult authoriseCreateExchange(AMQProtocolSession session, boolean autoDelete, boolean durable, AMQShortString exchangeName, boolean internal, boolean nowait, boolean passive, AMQShortString exchangeType) {
        PrincipalPermissions principalPermissions = this._users.get(session.getAuthorizedID().getName());
        if (principalPermissions == null) {
            return ACLPlugin.AuthzResult.DENIED;
        }
        return principalPermissions.authorise(Permission.CREATEEXCHANGE, exchangeName);
    }

    public ACLPlugin.AuthzResult authoriseCreateQueue(AMQProtocolSession session, boolean autoDelete, boolean durable, boolean exclusive, boolean nowait, boolean passive, AMQShortString queue) {
        PrincipalPermissions principalPermissions = this._users.get(session.getAuthorizedID().getName());
        if (principalPermissions == null) {
            return ACLPlugin.AuthzResult.DENIED;
        }
        return principalPermissions.authorise(Permission.CREATEQUEUE, autoDelete, queue);
    }

    public ACLPlugin.AuthzResult authoriseDelete(AMQProtocolSession session, AMQQueue queue) {
        PrincipalPermissions principalPermissions = this._users.get(session.getAuthorizedID().getName());
        if (principalPermissions == null) {
            return ACLPlugin.AuthzResult.DENIED;
        }
        return principalPermissions.authorise(Permission.DELETE, new Object[0]);
    }

    public ACLPlugin.AuthzResult authoriseDelete(AMQProtocolSession session, Exchange exchange) {
        PrincipalPermissions principalPermissions = this._users.get(session.getAuthorizedID().getName());
        if (principalPermissions == null) {
            return ACLPlugin.AuthzResult.DENIED;
        }
        return principalPermissions.authorise(Permission.DELETE, new Object[0]);
    }

    public ACLPlugin.AuthzResult authorisePublish(AMQProtocolSession session, boolean immediate, boolean mandatory, AMQShortString routingKey, Exchange e) {
        PrincipalPermissions principalPermissions = this._users.get(session.getAuthorizedID().getName());
        if (principalPermissions == null) {
            return ACLPlugin.AuthzResult.DENIED;
        }
        return principalPermissions.authorise(Permission.PUBLISH, e, routingKey);
    }

    public ACLPlugin.AuthzResult authorisePurge(AMQProtocolSession session, AMQQueue queue) {
        PrincipalPermissions principalPermissions = this._users.get(session.getAuthorizedID().getName());
        if (principalPermissions == null) {
            return ACLPlugin.AuthzResult.DENIED;
        }
        return principalPermissions.authorise(Permission.PURGE, new Object[0]);
    }

    public ACLPlugin.AuthzResult authoriseUnbind(AMQProtocolSession session, Exchange exch, AMQShortString routingKey, AMQQueue queue) {
        PrincipalPermissions principalPermissions = this._users.get(session.getAuthorizedID().getName());
        if (principalPermissions == null) {
            return ACLPlugin.AuthzResult.DENIED;
        }
        return principalPermissions.authorise(Permission.UNBIND, new Object[0]);
    }
}

