/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins.network;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.qpid.server.protocol.AMQMinaProtocolSession;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.security.access.ACLPlugin;
import org.apache.qpid.server.security.access.ACLPluginFactory;
import org.apache.qpid.server.security.access.plugins.AbstractACLPlugin;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.util.NetMatcher;

public class FirewallPlugin
extends AbstractACLPlugin {
    public static final ACLPluginFactory FACTORY = new ACLPluginFactory(){

        public boolean supportsTag(String name) {
            return name.startsWith("firewall");
        }

        public ACLPlugin newInstance(Configuration config) throws ConfigurationException {
            FirewallPlugin plugin = new FirewallPlugin();
            plugin.setConfiguration(config.subset("firewall"));
            return plugin;
        }
    };
    private ACLPlugin.AuthzResult _default = ACLPlugin.AuthzResult.ABSTAIN;
    private FirewallRule[] _rules;

    public ACLPlugin.AuthzResult authoriseConnect(AMQProtocolSession session, VirtualHost virtualHost) {
        if (!(session instanceof AMQMinaProtocolSession)) {
            return ACLPlugin.AuthzResult.ABSTAIN;
        }
        InetAddress addr = this.getInetAdressFromMinaSession((AMQMinaProtocolSession)session);
        if (addr == null) {
            return ACLPlugin.AuthzResult.ABSTAIN;
        }
        boolean match = false;
        for (FirewallRule rule : this._rules) {
            try {
                match = rule.match(addr);
            }
            catch (FirewallPluginException e) {
                return ACLPlugin.AuthzResult.DENIED;
            }
            if (!match) continue;
            return rule.getAccess();
        }
        return this._default;
    }

    private InetAddress getInetAdressFromMinaSession(AMQMinaProtocolSession session) {
        SocketAddress remote = session.getIOSession().getRemoteAddress();
        if (remote instanceof InetSocketAddress) {
            return ((InetSocketAddress)remote).getAddress();
        }
        return null;
    }

    public void setConfiguration(Configuration config) throws ConfigurationException {
        String defaultAction = config.getString("[@default-action]");
        this._default = defaultAction == null ? ACLPlugin.AuthzResult.ABSTAIN : (defaultAction.toLowerCase().equals("allow") ? ACLPlugin.AuthzResult.ALLOWED : ACLPlugin.AuthzResult.DENIED);
        CompositeConfiguration finalConfig = new CompositeConfiguration(config);
        List subFiles = config.getList("xml[@fileName]");
        for (Object subFile : subFiles) {
            finalConfig.addConfiguration((Configuration)new XMLConfiguration((String)subFile));
        }
        int numRules = finalConfig.getList("rule[@access]").size();
        this._rules = new FirewallRule[numRules];
        for (int i = 0; i < numRules; ++i) {
            FirewallRule rule;
            this._rules[i] = rule = new FirewallRule(finalConfig.getString("rule(" + i + ")[@access]"), finalConfig.getList("rule(" + i + ")[@network]"), finalConfig.getList("rule(" + i + ")[@hostname]"));
        }
    }

    public class FirewallRule {
        private static final long DNS_TIMEOUT = 30000L;
        private ACLPlugin.AuthzResult _access;
        private NetMatcher _network;
        private Pattern[] _hostnamePatterns;

        public FirewallRule(String access, List networks, List hostnames) {
            ACLPlugin.AuthzResult authzResult = this._access = access.equals("allow") ? ACLPlugin.AuthzResult.ALLOWED : ACLPlugin.AuthzResult.DENIED;
            if (networks != null && networks.size() > 0) {
                String[] networkStrings = this.objListToStringArray(networks);
                this._network = new NetMatcher(networkStrings);
            }
            if (hostnames != null && hostnames.size() > 0) {
                int i = 0;
                this._hostnamePatterns = new Pattern[hostnames.size()];
                for (String hostname : this.objListToStringArray(hostnames)) {
                    this._hostnamePatterns[i++] = Pattern.compile(hostname);
                }
            }
        }

        private String[] objListToStringArray(List objList) {
            String[] networkStrings = new String[objList.size()];
            int i = 0;
            for (Object network : objList) {
                networkStrings[i++] = (String)network;
            }
            return networkStrings;
        }

        public boolean match(InetAddress remote) throws FirewallPluginException {
            if (this._hostnamePatterns != null) {
                String hostname = this.getHostname(remote);
                if (hostname == null) {
                    throw new FirewallPluginException();
                }
                for (Pattern pattern : this._hostnamePatterns) {
                    if (!pattern.matcher(hostname).matches()) continue;
                    return true;
                }
                return false;
            }
            return this._network.matchInetNetwork(remote);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHostname(final InetAddress remote) {
            final String[] hostname = new String[]{null};
            final AtomicBoolean done = new AtomicBoolean(false);
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    hostname[0] = remote.getCanonicalHostName();
                    done.getAndSet(true);
                    AtomicBoolean atomicBoolean = done;
                    synchronized (atomicBoolean) {
                        done.notifyAll();
                    }
                }
            });
            thread.run();
            long endTime = System.currentTimeMillis() + 30000L;
            while (System.currentTimeMillis() < endTime && !done.get()) {
                try {
                    AtomicBoolean atomicBoolean = done;
                    synchronized (atomicBoolean) {
                        done.wait(endTime - System.currentTimeMillis());
                    }
                }
                catch (InterruptedException e) {
                }
            }
            return hostname[0];
        }

        public ACLPlugin.AuthzResult getAccess() {
            return this._access;
        }
    }

    public class FirewallPluginException
    extends Exception {
    }
}

