/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class HashedUser
implements Principal {
    private static final Logger _logger = Logger.getLogger(HashedUser.class);
    String _name;
    char[] _password;
    byte[] _encodedPassword = null;
    private boolean _modified = false;
    private boolean _deleted = false;

    HashedUser(String[] data) throws UnsupportedEncodingException {
        if (data.length != 2) {
            throw new IllegalArgumentException("User Data should be length 2, username, password");
        }
        this._name = data[0];
        byte[] encoded_password = data[1].getBytes("utf-8");
        Base64 b64 = new Base64();
        byte[] decoded = b64.decode(encoded_password);
        this._encodedPassword = encoded_password;
        this._password = new char[decoded.length];
        int index = 0;
        for (byte c : decoded) {
            this._password[index++] = (char)c;
        }
    }

    public HashedUser(String name, char[] password) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        this._name = name;
        this.setPassword(password, false);
    }

    public static byte[] getMD5(byte[] data) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        for (byte b : data) {
            md.update(b);
        }
        return md.digest();
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    char[] getPassword() {
        return this._password;
    }

    void setPassword(char[] password, boolean alreadyHashed) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (alreadyHashed) {
            this._password = password;
        } else {
            byte[] byteArray = new byte[password.length];
            int index = 0;
            for (char c : password) {
                byteArray[index++] = (byte)c;
            }
            byte[] MD5byteArray = HashedUser.getMD5(byteArray);
            this._password = new char[MD5byteArray.length];
            index = 0;
            for (byte c : MD5byteArray) {
                this._password[index++] = (char)c;
            }
        }
        this._modified = true;
        this._encodedPassword = null;
    }

    byte[] getEncodedPassword() throws EncoderException, UnsupportedEncodingException, NoSuchAlgorithmException {
        if (this._encodedPassword == null) {
            this.encodePassword();
        }
        return this._encodedPassword;
    }

    private void encodePassword() throws EncoderException, UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] byteArray = new byte[this._password.length];
        int index = 0;
        for (char c : this._password) {
            byteArray[index++] = (byte)c;
        }
        this._encodedPassword = new Base64().encode(byteArray);
    }

    public boolean isModified() {
        return this._modified;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    public void delete() {
        this._deleted = true;
    }

    public void saved() {
        this._modified = false;
    }
}

