/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.rmi;

import java.util.Collections;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;

public class RMIPasswordAuthenticator
implements JMXAuthenticator {
    static final String UNABLE_TO_LOOKUP = "The broker was unable to lookup the user details";
    static final String SHOULD_BE_STRING_ARRAY = "User details should be String[]";
    static final String SHOULD_HAVE_2_ELEMENTS = "User details should have 2 elements, username, password";
    static final String SHOULD_BE_NON_NULL = "Supplied username and password should be non-null";
    static final String INVALID_CREDENTIALS = "Invalid user details supplied";
    static final String CREDENTIALS_REQUIRED = "User details are required. Please ensure you are using an up to date management console to connect.";
    private PrincipalDatabase _db = null;

    public void setPrincipalDatabase(PrincipalDatabase pd) {
        this._db = pd;
    }

    public Subject authenticate(Object credentials) throws SecurityException {
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                throw new SecurityException(CREDENTIALS_REQUIRED);
            }
            throw new SecurityException(SHOULD_BE_STRING_ARRAY);
        }
        String[] userCredentials = (String[])credentials;
        if (userCredentials.length != 2) {
            throw new SecurityException(SHOULD_HAVE_2_ELEMENTS);
        }
        String username = userCredentials[0];
        String password = userCredentials[1];
        if (username == null || password == null) {
            throw new SecurityException(SHOULD_BE_NON_NULL);
        }
        if (this._db == null) {
            throw new SecurityException(UNABLE_TO_LOOKUP);
        }
        boolean authenticated = false;
        try {
            if (this._db.verifyPassword(username, password.toCharArray())) {
                authenticated = true;
            }
        }
        catch (AccountNotFoundException e) {
            throw new SecurityException(INVALID_CREDENTIALS);
        }
        if (authenticated) {
            return new Subject(true, Collections.singleton(new JMXPrincipal(username)), Collections.EMPTY_SET, Collections.EMPTY_SET);
        }
        throw new SecurityException(INVALID_CREDENTIALS);
    }
}

