/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.MessageMetaData;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreClosedException;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryMessageStore
implements MessageStore {
    private static final Logger _log = Logger.getLogger(MemoryMessageStore.class);
    private static final int DEFAULT_HASHTABLE_CAPACITY = 50000;
    private static final String HASHTABLE_CAPACITY_CONFIG = "hashtable-capacity";
    protected ConcurrentMap<Long, MessageMetaData> _metaDataMap;
    protected ConcurrentMap<Long, List<ContentChunk>> _contentBodyMap;
    private final AtomicLong _messageId = new AtomicLong(1L);
    private AtomicBoolean _closed = new AtomicBoolean(false);

    public void configure() {
        _log.info((Object)"Using capacity 50000 for hash tables");
        this._metaDataMap = new ConcurrentHashMap<Long, MessageMetaData>(50000);
        this._contentBodyMap = new ConcurrentHashMap<Long, List<ContentChunk>>(50000);
    }

    public void configure(String base, VirtualHostConfiguration config) {
        int hashtableCapacity = config.getStoreConfiguration().getInt(base + "." + HASHTABLE_CAPACITY_CONFIG, 50000);
        _log.info((Object)("Using capacity " + hashtableCapacity + " for hash tables"));
        this._metaDataMap = new ConcurrentHashMap<Long, MessageMetaData>(hashtableCapacity);
        this._contentBodyMap = new ConcurrentHashMap<Long, List<ContentChunk>>(hashtableCapacity);
    }

    @Override
    public void configure(VirtualHost virtualHost, String base, VirtualHostConfiguration config) throws Exception {
        this.configure(base, config);
    }

    @Override
    public void close() throws Exception {
        this._closed.getAndSet(true);
        if (this._metaDataMap != null) {
            this._metaDataMap.clear();
            this._metaDataMap = null;
        }
        if (this._contentBodyMap != null) {
            this._contentBodyMap.clear();
            this._contentBodyMap = null;
        }
    }

    @Override
    public void removeMessage(StoreContext context, Long messageId) throws AMQException {
        this.checkNotClosed();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Removing message with id " + messageId));
        }
        this._metaDataMap.remove(messageId);
        this._contentBodyMap.remove(messageId);
    }

    @Override
    public void createExchange(Exchange exchange) throws AMQException {
    }

    @Override
    public void removeExchange(Exchange exchange) throws AMQException {
    }

    @Override
    public void bindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQException {
    }

    @Override
    public void unbindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQException {
    }

    @Override
    public void createQueue(AMQQueue queue) throws AMQException {
    }

    @Override
    public void createQueue(AMQQueue queue, FieldTable arguments) throws AMQException {
    }

    @Override
    public void removeQueue(AMQQueue queue) throws AMQException {
    }

    @Override
    public void enqueueMessage(StoreContext context, AMQQueue queue, Long messageId) throws AMQException {
    }

    @Override
    public void dequeueMessage(StoreContext context, AMQQueue queue, Long messageId) throws AMQException {
    }

    @Override
    public void beginTran(StoreContext context) throws AMQException {
    }

    @Override
    public void commitTran(StoreContext context) throws AMQException {
    }

    @Override
    public void abortTran(StoreContext context) throws AMQException {
    }

    @Override
    public boolean inTran(StoreContext context) {
        return false;
    }

    public List<AMQQueue> createQueues() throws AMQException {
        return null;
    }

    @Override
    public Long getNewMessageId() {
        return this._messageId.getAndIncrement();
    }

    @Override
    public void storeContentBodyChunk(StoreContext context, Long messageId, int index, ContentChunk contentBody, boolean lastContentBody) throws AMQException {
        this.checkNotClosed();
        ArrayList<ContentChunk> bodyList = (ArrayList<ContentChunk>)this._contentBodyMap.get(messageId);
        if (bodyList == null && lastContentBody) {
            this._contentBodyMap.put(messageId, Collections.singletonList(contentBody));
        } else {
            if (bodyList == null) {
                bodyList = new ArrayList<ContentChunk>();
                this._contentBodyMap.put(messageId, bodyList);
            }
            bodyList.add(index, contentBody);
        }
    }

    @Override
    public void storeMessageMetaData(StoreContext context, Long messageId, MessageMetaData messageMetaData) throws AMQException {
        this.checkNotClosed();
        this._metaDataMap.put(messageId, messageMetaData);
    }

    @Override
    public MessageMetaData getMessageMetaData(StoreContext context, Long messageId) throws AMQException {
        this.checkNotClosed();
        return (MessageMetaData)this._metaDataMap.get(messageId);
    }

    @Override
    public ContentChunk getContentBodyChunk(StoreContext context, Long messageId, int index) throws AMQException {
        this.checkNotClosed();
        List bodyList = (List)this._contentBodyMap.get(messageId);
        return (ContentChunk)bodyList.get(index);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    private void checkNotClosed() throws MessageStoreClosedException {
        if (this._closed.get()) {
            throw new MessageStoreClosedException();
        }
    }
}

