/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.MessageMetaData;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.virtualhost.VirtualHost;

public interface MessageStore {
    public void configure(VirtualHost var1, String var2, VirtualHostConfiguration var3) throws Exception;

    public void close() throws Exception;

    public void removeMessage(StoreContext var1, Long var2) throws AMQException;

    public void createExchange(Exchange var1) throws AMQException;

    public void removeExchange(Exchange var1) throws AMQException;

    public void bindQueue(Exchange var1, AMQShortString var2, AMQQueue var3, FieldTable var4) throws AMQException;

    public void unbindQueue(Exchange var1, AMQShortString var2, AMQQueue var3, FieldTable var4) throws AMQException;

    public void createQueue(AMQQueue var1) throws AMQException;

    public void createQueue(AMQQueue var1, FieldTable var2) throws AMQException;

    public void removeQueue(AMQQueue var1) throws AMQException;

    public void enqueueMessage(StoreContext var1, AMQQueue var2, Long var3) throws AMQException;

    public void dequeueMessage(StoreContext var1, AMQQueue var2, Long var3) throws AMQException;

    public void beginTran(StoreContext var1) throws AMQException;

    public void commitTran(StoreContext var1) throws AMQException;

    public void abortTran(StoreContext var1) throws AMQException;

    public boolean inTran(StoreContext var1);

    public Long getNewMessageId();

    public void storeContentBodyChunk(StoreContext var1, Long var2, int var3, ContentChunk var4, boolean var5) throws AMQException;

    public void storeMessageMetaData(StoreContext var1, Long var2, MessageMetaData var3) throws AMQException;

    public MessageMetaData getMessageMetaData(StoreContext var1, Long var2) throws AMQException;

    public ContentChunk getContentBodyChunk(StoreContext var1, Long var2, int var3) throws AMQException;

    public boolean isPersistent();
}

