/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.subscription;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.common.ClientProperties;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterManagerFactory;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.subscription.ClientDeliveryMethod;
import org.apache.qpid.server.subscription.RecordDeliveryMethod;
import org.apache.qpid.server.subscription.Subscription;

public abstract class SubscriptionImpl
implements Subscription,
FlowCreditManager.FlowCreditManagerListener {
    private Subscription.StateListener _stateListener = new Subscription.StateListener(){

        public void stateChange(Subscription sub, Subscription.State oldState, Subscription.State newState) {
        }
    };
    private final AtomicReference<Subscription.State> _state = new AtomicReference<Subscription.State>(Subscription.State.ACTIVE);
    private final AtomicReference<QueueEntry> _queueContext = new AtomicReference<Object>(null);
    private final ClientDeliveryMethod _deliveryMethod;
    private final RecordDeliveryMethod _recordMethod;
    private QueueEntry.SubscriptionAcquiredState _owningState = new QueueEntry.SubscriptionAcquiredState(this);
    private final Lock _stateChangeLock;
    private static final Logger _logger = Logger.getLogger(SubscriptionImpl.class);
    private final AMQChannel _channel;
    private final AMQShortString _consumerTag;
    private final boolean _noLocal;
    private final FlowCreditManager _creditManager;
    private FilterManager _filters;
    private final Boolean _autoClose;
    private static final String CLIENT_PROPERTIES_INSTANCE = ClientProperties.instance.toString();
    private AMQQueue _queue;
    private final AtomicBoolean _deleted = new AtomicBoolean(false);
    private String id = String.valueOf(System.identityHashCode(this));

    public SubscriptionImpl(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, FieldTable arguments, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod) throws AMQException {
        Object autoClose;
        this._channel = channel;
        this._consumerTag = consumerTag;
        this._creditManager = creditManager;
        creditManager.addStateListener(this);
        this._noLocal = noLocal;
        this._filters = FilterManagerFactory.createManager(arguments);
        this._deliveryMethod = deliveryMethod;
        this._recordMethod = recordMethod;
        this._stateChangeLock = new ReentrantLock();
        this._autoClose = arguments != null ? ((autoClose = arguments.get(AMQPFilterTypes.AUTO_CLOSE.getValue())) != null ? (Boolean)autoClose : Boolean.valueOf(false)) : Boolean.valueOf(false);
    }

    public synchronized void setQueue(AMQQueue queue) {
        if (this.getQueue() != null) {
            throw new IllegalStateException("Attempt to set queue for subscription " + this + " to " + queue + "when already set to " + this.getQueue());
        }
        this._queue = queue;
    }

    public String toString() {
        String subscriber = "[channel=" + this._channel + ", consumerTag=" + this._consumerTag + ", session=" + this.getProtocolSession().getKey();
        return subscriber + "]";
    }

    public abstract void send(QueueEntry var1) throws AMQException;

    public boolean isSuspended() {
        return !this.isActive() || this._channel.isSuspended() || this._deleted.get();
    }

    public void queueDeleted(AMQQueue queue) {
        this._deleted.set(true);
    }

    public boolean filtersMessages() {
        return this._filters != null || this._noLocal;
    }

    public boolean hasInterest(QueueEntry entry) {
        Object localInstance;
        Object publisherId;
        if (entry.isRejectedBy(this) && _logger.isDebugEnabled()) {
            _logger.debug((Object)("Subscription:" + this.debugIdentity() + " rejected message:" + entry.debugIdentity()));
        }
        if (this._noLocal && ((publisherId = entry.getMessage().getPublisherClientInstance()) != null && this.getProtocolSession().getClientProperties() != null && (localInstance = this.getProtocolSession().getClientProperties().getObject(CLIENT_PROPERTIES_INSTANCE)) != null ? publisherId.equals(localInstance) : (localInstance = this.getProtocolSession().getClientIdentifier()) != null && localInstance.equals(entry.getMessage().getPublisherIdentifier()))) {
            return false;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("(" + this.debugIdentity() + ") checking filters for message (" + entry.debugIdentity()));
        }
        return this.checkFilters(entry);
    }

    private String debugIdentity() {
        return this.id;
    }

    private boolean checkFilters(QueueEntry msg) {
        return this._filters == null || this._filters.allAllow(msg.getMessage());
    }

    public boolean isAutoClose() {
        return this._autoClose;
    }

    public FlowCreditManager getCreditManager() {
        return this._creditManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean closed = false;
        Subscription.State state = this.getState();
        this._stateChangeLock.lock();
        try {
            while (!closed && state != Subscription.State.CLOSED) {
                closed = this._state.compareAndSet(state, Subscription.State.CLOSED);
                if (!closed) {
                    state = this.getState();
                    continue;
                }
                this._stateListener.stateChange(this, state, Subscription.State.CLOSED);
            }
            this._creditManager.removeListener(this);
        }
        finally {
            this._stateChangeLock.unlock();
        }
        if (closed) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"Called close() on a closed subscription");
            }
            return;
        }
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Closing subscription (" + this.debugIdentity() + "):" + this));
        }
    }

    public boolean isClosed() {
        return this.getState() == Subscription.State.CLOSED;
    }

    public boolean wouldSuspend(QueueEntry msg) {
        return !this._creditManager.useCreditForMessage(msg.getMessage());
    }

    public void getSendLock() {
        this._stateChangeLock.lock();
    }

    public void releaseSendLock() {
        this._stateChangeLock.unlock();
    }

    public void resend(QueueEntry entry) throws AMQException {
        this._queue.resend(entry, this);
    }

    public AMQChannel getChannel() {
        return this._channel;
    }

    public AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    public AMQProtocolSession getProtocolSession() {
        return this._channel.getProtocolSession();
    }

    public AMQQueue getQueue() {
        return this._queue;
    }

    public void restoreCredit(QueueEntry queueEntry) {
        this._creditManager.addCredit(1L, queueEntry.getSize());
    }

    public void creditStateChanged(boolean hasCredit) {
        if (hasCredit) {
            if (this._state.compareAndSet(Subscription.State.SUSPENDED, Subscription.State.ACTIVE)) {
                this._stateListener.stateChange(this, Subscription.State.SUSPENDED, Subscription.State.ACTIVE);
            } else {
                this._stateListener.stateChange(this, Subscription.State.ACTIVE, Subscription.State.ACTIVE);
            }
        } else if (this._state.compareAndSet(Subscription.State.ACTIVE, Subscription.State.SUSPENDED)) {
            this._stateListener.stateChange(this, Subscription.State.ACTIVE, Subscription.State.SUSPENDED);
        }
    }

    public Subscription.State getState() {
        return this._state.get();
    }

    public void setStateListener(Subscription.StateListener listener) {
        this._stateListener = listener;
    }

    public QueueEntry getLastSeenEntry() {
        return this._queueContext.get();
    }

    public boolean setLastSeenEntry(QueueEntry expected, QueueEntry newvalue) {
        return this._queueContext.compareAndSet(expected, newvalue);
    }

    protected void sendToClient(QueueEntry entry, long deliveryTag) throws AMQException {
        this._deliveryMethod.deliverToClient(this, entry, deliveryTag);
    }

    protected void recordMessageDelivery(QueueEntry entry, long deliveryTag) {
        this._recordMethod.recordMessageDelivery(this, entry, deliveryTag);
    }

    public boolean isActive() {
        return this.getState() == Subscription.State.ACTIVE;
    }

    public QueueEntry.SubscriptionAcquiredState getOwningState() {
        return this._owningState;
    }

    static final class AckSubscription
    extends SubscriptionImpl {
        public AckSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod) throws AMQException {
            super(channel, protocolSession, consumerTag, filters, noLocal, creditManager, deliveryMethod, recordMethod);
        }

        public boolean isBrowser() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(QueueEntry entry) throws AMQException {
            try {
                AMQChannel aMQChannel = this.getChannel();
                synchronized (aMQChannel) {
                    long deliveryTag = this.getChannel().getNextDeliveryTag();
                    this.recordMessageDelivery(entry, deliveryTag);
                    this.sendToClient(entry, deliveryTag);
                }
            }
            finally {
                entry.setDeliveredToSubscription();
            }
        }
    }

    public static class NoAckSubscription
    extends SubscriptionImpl {
        public NoAckSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod) throws AMQException {
            super(channel, protocolSession, consumerTag, filters, noLocal, creditManager, deliveryMethod, recordMethod);
        }

        public boolean isBrowser() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(QueueEntry entry) throws AMQException {
            StoreContext storeContext = this.getChannel().getStoreContext();
            try {
                entry.dequeue(storeContext);
                AMQChannel aMQChannel = this.getChannel();
                synchronized (aMQChannel) {
                    long deliveryTag = this.getChannel().getNextDeliveryTag();
                    this.sendToClient(entry, deliveryTag);
                }
                entry.dispose(storeContext);
            }
            finally {
                entry.setDeliveredToSubscription();
            }
        }

        public boolean wouldSuspend(QueueEntry msg) {
            return false;
        }
    }

    static final class BrowserSubscription
    extends SubscriptionImpl {
        public BrowserSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod) throws AMQException {
            super(channel, protocolSession, consumerTag, filters, noLocal, creditManager, deliveryMethod, recordMethod);
        }

        public boolean isBrowser() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(QueueEntry msg) throws AMQException {
            AMQChannel aMQChannel = this.getChannel();
            synchronized (aMQChannel) {
                long deliveryTag = this.getChannel().getNextDeliveryTag();
                this.sendToClient(msg, deliveryTag);
            }
        }

        public boolean wouldSuspend(QueueEntry msg) {
            return false;
        }
    }
}

