/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.subscription;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.subscription.Subscription;

public class SubscriptionList {
    private final SubscriptionNode _head = new SubscriptionNode();
    private AtomicReference<SubscriptionNode> _tail = new AtomicReference<SubscriptionNode>(this._head);
    private final AMQQueue _queue;
    private AtomicInteger _size = new AtomicInteger();

    public SubscriptionList(AMQQueue queue) {
        this._queue = queue;
    }

    private void advanceHead() {
        SubscriptionNode head = this._head.nextNode();
        while (head._next.get() != null && head.isDeleted()) {
            SubscriptionNode newhead = head.nextNode();
            if (newhead != null) {
                this._head._next.compareAndSet(head, newhead);
            }
            head = this._head.nextNode();
        }
    }

    public SubscriptionNode add(Subscription sub) {
        SubscriptionNode node = new SubscriptionNode(sub);
        while (true) {
            SubscriptionNode tail = this._tail.get();
            SubscriptionNode next = tail.nextNode();
            if (tail != this._tail.get()) continue;
            if (next == null) {
                if (!tail._next.compareAndSet(null, node)) continue;
                this._tail.compareAndSet(tail, node);
                this._size.incrementAndGet();
                return node;
            }
            this._tail.compareAndSet(tail, next);
        }
    }

    public boolean remove(Subscription sub) {
        for (SubscriptionNode node = this._head.getNext(); node != null; node = node.getNext()) {
            if (!sub.equals(node._sub) || !node.delete()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionNodeIterator iterator() {
        return new SubscriptionNodeIterator(this._head);
    }

    public SubscriptionNode getHead() {
        return this._head;
    }

    public int size() {
        return this._size.get();
    }

    public class SubscriptionNodeIterator {
        private SubscriptionNode _lastNode;

        SubscriptionNodeIterator(SubscriptionNode startNode) {
            this._lastNode = startNode;
        }

        public boolean atTail() {
            return this._lastNode.nextNode() == null;
        }

        public SubscriptionNode getNode() {
            return this._lastNode;
        }

        public boolean advance() {
            if (!this.atTail()) {
                SubscriptionNode nextNode = this._lastNode.nextNode();
                while (nextNode.isDeleted() && nextNode.nextNode() != null) {
                    nextNode = nextNode.nextNode();
                }
                this._lastNode = nextNode;
                return true;
            }
            return false;
        }
    }

    public final class SubscriptionNode {
        private final AtomicBoolean _deleted = new AtomicBoolean();
        private final AtomicReference<SubscriptionNode> _next = new AtomicReference();
        private final Subscription _sub;

        public SubscriptionNode() {
            this._sub = null;
            this._deleted.set(true);
        }

        public SubscriptionNode(Subscription sub) {
            this._sub = sub;
        }

        public SubscriptionNode getNext() {
            SubscriptionNode next = this.nextNode();
            while (next != null && next.isDeleted()) {
                SubscriptionNode newNext = next.nextNode();
                if (newNext != null) {
                    this._next.compareAndSet(next, newNext);
                    next = this.nextNode();
                    continue;
                }
                next = null;
            }
            return next;
        }

        private SubscriptionNode nextNode() {
            return this._next.get();
        }

        public boolean isDeleted() {
            return this._deleted.get();
        }

        public boolean delete() {
            if (this._deleted.compareAndSet(false, true)) {
                SubscriptionList.this._size.decrementAndGet();
                SubscriptionList.this.advanceHead();
                return true;
            }
            return false;
        }

        public Subscription getSubscription() {
            return this._sub;
        }
    }
}

