/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.txn.TxnOp;

public class TxnBuffer {
    private final List<TxnOp> _ops = new ArrayList<TxnOp>();
    private static final Logger _log = Logger.getLogger(TxnBuffer.class);

    public void commit(StoreContext context) throws AMQException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Committing " + this._ops.size() + " ops to commit.:" + this._ops));
        }
        if (this.prepare(context)) {
            for (TxnOp op : this._ops) {
                op.commit(context);
            }
        }
        this._ops.clear();
    }

    private boolean prepare(StoreContext context) throws AMQException {
        for (int i = 0; i < this._ops.size(); ++i) {
            TxnOp op = this._ops.get(i);
            try {
                op.prepare(context);
                continue;
            }
            catch (AMQException e) {
                this.undoPrepare(i);
                throw e;
            }
            catch (RuntimeException e) {
                this.undoPrepare(i);
                throw e;
            }
        }
        return true;
    }

    private void undoPrepare(int lastPrepared) {
        for (int j = 0; j < lastPrepared; ++j) {
            this._ops.get(j).undoPrepare();
        }
    }

    public void rollback(StoreContext context) throws AMQException {
        for (TxnOp op : this._ops) {
            op.rollback(context);
        }
        this._ops.clear();
    }

    public void enlist(TxnOp op) {
        this._ops.add(op);
    }

    public void cancel(TxnOp op) {
        this._ops.remove(op);
    }
}

